// DarkVIDEO.h
// (C) 2008-2010, Deep Cove Software, Ltd.

#pragma once

#include <windows.h>
#include <d3d9.h>

#define DARKVIDEO_COMMAND __declspec( dllexport )

DARKVIDEO_COMMAND void Constructor( void );
DARKVIDEO_COMMAND void Destructor( void );
DARKVIDEO_COMMAND void ReceiveCoreDataPtr( LPVOID pCore );

typedef IDirect3DTexture9* ( *fnGET_D3D9_TEXTURE )( int );

extern "C"
{
	DARKVIDEO_COMMAND void DarkVideoInitialize();
	DARKVIDEO_COMMAND void DarkVideoShutdown();
	DARKVIDEO_COMMAND int DarkVideoOpen( LPSTR strPath );
	DARKVIDEO_COMMAND int DarkVideoClose( int movieId );
	DARKVIDEO_COMMAND int DarkVideoPlay( int movieId, int imageId, int loop, fnGET_D3D9_TEXTURE fn );
	DARKVIDEO_COMMAND int DarkVideoStop( int movieId );
	DARKVIDEO_COMMAND int DarkVideoGetWidth( int movieId );
	DARKVIDEO_COMMAND int DarkVideoGetHeight( int movieId );
	DARKVIDEO_COMMAND int DarkVideoGetVolume( int movieId );
	DARKVIDEO_COMMAND int DarkVideoSetVolume( int movieId, int volume );
	DARKVIDEO_COMMAND int DarkVideoIsLooping( int movieId );
	DARKVIDEO_COMMAND int DarkVideoIsFinished( int movieId );
	DARKVIDEO_COMMAND int DarkVideoGetCurrentFrame( int movieId );
	DARKVIDEO_COMMAND double DarkVideoGetFrameRate( int movieId );
	DARKVIDEO_COMMAND int DarkVideoGetNumberOfFrames( int movieId );
	DARKVIDEO_COMMAND int DarkVideoSeekToFrame( int movieId, int frame );	
}
