//====================================================
// Cubemap Refractive+Reflective Glass
// By: Jesse George
//====================================================

//--------------
// Un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;   
   matrix ViewInv:ViewInverse; 

//--------------
// Tweaks
//--------------
   float RefractAmount=0.8f;
   float3 RefractColor={1.0f,1.0f,1.1f}; 
   float4 FogColor={0.8f,0.8f,0.8f,1.0f};
   float FogRange=2500.0f;
   float FogPow=1.0f;

//--------------
// Textures
//--------------
   texture EnvCube <string Name="";>;
   samplerCUBE EnvCubeTex=sampler_state 
    {
 	texture=<EnvCube>;
    };

//--------------
// Structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION; 
	float3 Normal:NORMAL;
     };
   struct output
     {
 	float4 OPos:POSITION; 
	float3 WNorm:TEXCOORD0;
	float3 ViewVec:TEXCOORD1;
	float Fog:FOG;
     };

//--------------
// Vertex shader
//--------------
   output VS(input IN)
     {
 	output OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
	float3 WPos=mul(IN.Pos,World);
	OUT.WNorm=normalize(mul(IN.Normal,(float3x3)World));
	float3 ViewPos=WPos-ViewInv[3].xyz;
	OUT.ViewVec=normalize(ViewPos);
	OUT.Fog=1-pow(length(ViewPos/FogRange),FogPow);
        return OUT;
     }




//--------------
// Pixel shader
//--------------
   float4 PS(output IN) : COLOR 
     {
	float angle = dot(IN.WNorm,IN.ViewVec);
	float3 RefractVec = refract(IN.ViewVec,IN.WNorm,saturate(1-angle)*RefractAmount);
        float3 refraction=texCUBE(EnvCubeTex,RefractVec)*RefractColor;
    	float3 ReflectVec=reflect(IN.ViewVec,IN.WNorm);
  	float3 reflection=texCUBE(EnvCubeTex,ReflectVec);
	return float4(lerp(refraction,reflection,1+angle),1.0f);
     }



//--------------
// techniques   
//--------------
    technique RefractReflect
      {
 	pass p1
      {		
 	VertexShader = compile vs_2_0 VS(); 
 	PixelShader  = compile ps_2_0 PS(); 
	FOGCOLOR=(FogColor); 
	FOGENABLE=TRUE;			
      }
      }
