//====================================================
// Glow H
//====================================================
// By EVOLVED
// www.evolved-software.com
//====================================================

//--------------
// tweaks
//--------------
   float2 ViewVec;
   float BloomOffset=0.003f;
   float BloomWeights[9]={0,0.092,0.081,0.071,0.061,0.051,0.041,0.031,0.021};

//--------------
// Textures
//--------------
   texture ColorsampleTX <string Name = " ";>;
   sampler Colorsample=sampler_state 
      {
	Texture=<ColorsampleTX>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 OPos:POSITION; 
 	float2 Tex:TEXCOORD0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.OPos=IN.Pos; 
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewVec;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
 	float3 Scene=tex2D(Colorsample,IN.Tex)*0.102f;
   	for (int i = 1; i < 9; i++) Scene +=tex2D(Colorsample,IN.Tex+float2(i*BloomOffset,0))*BloomWeights[i];
     	for (int i = 1; i < 9; i++) Scene +=tex2D(Colorsample,IN.Tex+float2(-i*BloomOffset,0))*BloomWeights[i];
	return float4(Scene*1.05,1);	
     }    

//--------------
// techniques   
//--------------
    technique BloomH
      {
 	pass p1
      {		
 	VertexShader = compile vs_2_0 VS(); 
 	PixelShader  = compile ps_2_0 PS(); 
	zwriteenable=false;
	zenable=false;	
      }
      }


 