//====================================================
// Bright Pass
//====================================================
// By EVOLVED
// www.evolved-software.com
//====================================================

//--------------
// tweaks
//--------------
   float2 ViewVec;
   float TonePower=1.333f;
   float2 DownFilteroffset[9]={{-1,-1},{-1,1},{1,-1},{1,1},{-0.5,0},{0,-0.5},{0,0.5},{0.5,0},{0,0}};

//--------------
// Textures
//--------------
   texture ColorsampleTX <string Name = " ";>;
   sampler Colorsample=sampler_state 
      {
	Texture=<ColorsampleTX>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;
      };
   texture GlobLumColorTX <string Name = " ";>;
   sampler GlobLumColor=sampler_state 
      {
	Texture=<GlobLumColorTX>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 OPos:POSITION; 
 	float2 Tex:TEXCOORD0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.OPos=IN.Pos; 
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewVec;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
    {
	float3 Scene=0;
 	for (int i = 0; i < 9; i++) Scene +=tex2D(Colorsample,IN.Tex+(DownFilteroffset[i]*0.002f));
	Scene /=9;
	float Luminance=0.25f+tex2D(GlobLumColor,IN.Tex)*0.5;
      	return float4(Scene*pow(dot(Scene*(0.6f/Luminance),float3(0.3f,0.3f,0.4f)),TonePower),1);
    }  

//--------------
// techniques   
//--------------
    technique BrightPass
      {
 	pass p1
      {		
 	VertexShader = compile vs_2_0 VS(); 
 	PixelShader  = compile ps_2_0 PS();
	zwriteenable=false;
	zenable=false;	 
      }
      }