//====================================================
// Cube Mapping with Velocity
//====================================================
// By EVOLVED
// www.evolved-software.com
//====================================================

//--------------
// un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;   
   matrix ViewInv:ViewInverse; 

//--------------
// tweaks
//--------------
   float3 LightColor={1.0f,1.0f,1.0f};
   float3 Lightdir={0.5f,-0.5f,-0.5f};
   float3 Ambient={0.2f,0.2f,0.2f};
   float ReflectFactor=0.5f;
   float4 FogColor={0.5f,0.2f,0.2f,1.0f};
   float FogRange=20000.0f;
   float Alpha=1.0f;
 
//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler2D Base = sampler_state 
      {
     	texture = <BaseTX>;
      };
   texture cubeMapTX : ENVIRONMENT <string Name = ""; >;
   samplerCUBE cubeMap = sampler_state 
      {
	Texture = <cubeMapTX>;
      };

//--------------
// structs 
//--------------
   struct input
       {
 	float4 Pos:POSITION;
    	float2 UV:TEXCOORD; 
 	float3 Normal:NORMAL;  
       };
   struct output
       {
 	float4 OPos:POSITION; 
    	float2 Tex:TEXCOORD0; 
 	float3 Ref:TEXCOORD1; 
 	float3 Normals:TEXCOORD2; 
	float Fog:FOG;
       };

//--------------
// vertex shader
//--------------
   output VS(input IN) 
    {
 	output OUT;
	OUT.OPos=mul(IN.Pos,WorldVP);
 	OUT.Tex=IN.UV;
	float3 WNor=mul(IN.Normal,World); WNor=normalize(WNor);
	float3 WPos=mul(IN.Pos,World); 
	float3 View=WPos-ViewInv[3].xyz; 
	OUT.Ref=reflect(View,WNor); 
	OUT.Normals=WNor;
 	OUT.Fog=1-saturate(dot(View/FogRange,View/FogRange));
	return OUT;
    }

//--------------
// pixel shader
//--------------
    float4 PS(output IN)  : COLOR
     {		
   	float4 Texture=tex2D(Base,IN.Tex);
	float3 Cube=texCUBE(cubeMap,IN.Ref);
	float Light=saturate(dot(-Lightdir,IN.Normals));
	return float4(lerp(Texture,Cube,ReflectFactor)*((Light*LightColor)+Ambient),Texture.w*Alpha);
     }

//--------------
// techniques   
//--------------
    technique Cubemap
      {
 	pass p1
      {		
 	vertexShader = compile vs_2_0 VS(); 
 	pixelShader  = compile ps_2_0 PS();	
	FOGCOLOR=(FogColor); 
	FOGENABLE=TRUE;	
      }
      }


//====================================================
// Velocity + Depth
//====================================================

//tweaks
   matrix PreviousVP;
   matrix PreviousWorld;
   float NereFocus=50.0f;
   float FarFocus=500.0f;

//structs 
   struct IN_Velocity
       {
        float4 Pos:POSITION;
       };
   struct OUT_Velocity
       {
 	float4 OPos:POSITION; 
    	float4 CurrentPos:TEXCOORD0; 
    	float4 PreviousPos:TEXCOORD1; 
     	float Depth:TEXCOORD2;
       };
   struct input_Black
       {
 	float4 Pos:POSITION;
       };
   struct output_Black
       {
 	float4 OPos:POSITION; 
       };

//vertex shader
   OUT_Velocity VS_Velocity(IN_Velocity IN) 
    {
 	OUT_Velocity OUT;
	OUT.OPos=mul(IN.Pos,WorldVP);
 	OUT.CurrentPos=mul(IN.Pos,WorldVP);
	OUT.PreviousPos=mul(mul(IN.Pos,PreviousWorld),PreviousVP);
        OUT.Depth=OUT.OPos.z; 
	return OUT;
    }
   output_Black VS_Black(input_Black IN) 
     {
 	output_Black OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
	return OUT;
     }

//pixel shader
    float4 PS_Velocity(OUT_Velocity IN)  : COLOR
     {		
   	float2 velocity=((IN.CurrentPos/IN.CurrentPos.w)-(IN.PreviousPos/IN.PreviousPos.w));
        float CloseDepth=saturate(1-(IN.Depth/NereFocus));	
        float FarDepth=CloseDepth+saturate((-NereFocus+IN.Depth)/FarFocus);	
	return float4(velocity,FarDepth,1);
     }
    float4 PS_Black(output_Black IN)  : COLOR
     {		
	return float4(0,0,0,1);
     }

// techniques   
    technique VelocityDOF
      {
 	pass p1
      {		
 	vertexShader = compile vs_2_0 VS_Velocity(); 
 	pixelShader  = compile ps_2_0 PS_Velocity();	
      }
      }
  technique Black
      {
 	pass p1
      {		
	vertexShader = compile vs_1_1 VS_Black(); 
 	pixelShader  = compile ps_1_1 PS_Black();
      }
      }
