//====================================================
// Final Comp
//====================================================
// By EVOLVED
// www.evolved-software.com
//====================================================

#define UsePixelBlur 1
#define UseBloom 1
#define UseDof 1
#define UseFlare 1
#define vignette 1

//--------------
// tweaks
//--------------
   float2 ViewVec1;
   float2 ViewVec2;
   float2 ViewVec3;
   float3 ScreenColor={0.6f,0.6f,0.6f};
   float MotionTrails=1.0f;
   float PixelBlur=0.8f;
   float Gray=0.1f;
   float Sepia=0.2f;
   float4x4 GrayColor={0.3,0.5,0.2,0, 0.3,0.5,0.2,0, 0.3,0.5,0.2,0, 0,0,0,1};
   float4x4 SepiaColor={0.393,0.769,0.189,0, 0.349,0.686,0.168,0, 0.272,0.534,0.131,0, 0,0,0,1};

//--------------
// Textures
//--------------
   texture RenderColorTX <string Name = " ";>;
   sampler RenderColor=sampler_state 
      {
	Texture=<RenderColorTX>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;
      };
   texture velocityDOFTX <string Name=" ";>;
   sampler velocityDOF=sampler_state 
      {
	Texture=<velocityDOFTX>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
      };
   texture GlobLumColorTX <string Name = " ";>;
   sampler GlobLumColor=sampler_state 
      {
	Texture=<GlobLumColorTX>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
      };
   texture BloomColorTX <string Name=" ";>;
   sampler BloomColor=sampler_state 
      {
	Texture=<BloomColorTX>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture BlurColorTX <string Name=" ";>;
   sampler BlurColor=sampler_state 
      {
	Texture=<BlurColorTX>;
     	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
        ADDRESSW=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 OPos:POSITION; 
 	float2 Tex1:TEXCOORD0;
 	float2 Tex2:TEXCOORD1;
 	float2 Tex3:TEXCOORD2;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.OPos=IN.Pos; 
 	OUT.Tex1=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewVec1;
 	OUT.Tex2=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewVec2;
 	OUT.Tex3=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewVec3;
	return OUT;
    }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	float3 Scene=tex2D(RenderColor,IN.Tex1);
	float3 VelocDOF=tex2D(velocityDOF,IN.Tex1);
	#if UsePixelBlur == 1
	 float2 pixelVelocity=VelocDOF.xy*PixelBlur;
	 pixelVelocity.x=-pixelVelocity.x;
	 for (float i=1;i<10;i++)
	 {       
	  Scene +=tex2D(RenderColor,IN.Tex1+(pixelVelocity*(i/9)));
	 }
	 Scene /=10;
	#endif
	#if UseDof == 1
	 float3 Blur=tex2D(BlurColor,IN.Tex2);
	 Scene=lerp(Scene,Blur,VelocDOF.z);
	#endif
	#if UseBloom == 1
	  float3 Bloom=tex2D(BloomColor,IN.Tex3);
  	  float lerpFac=0.6f-(dot(Scene,float3(0.3f,0.3f,0.4f))*0.5f);
	 #if UseFlare == 1
	   Bloom=Bloom+pow(tex2D(BloomColor,1-IN.Tex1)*float3(0.3,0.25,0.25),3.0f);
	   Bloom=Bloom+pow(tex2D(BloomColor,0.75f-IN.Tex1*0.5f)*float3(0.25,0.25,0.3),3.0f);
	   Bloom=Bloom+pow(tex2D(BloomColor,(IN.Tex1*0.5f)+0.25f)*float3(0.25,0.3,0.25),3.0f);
  	 #endif
	 float Luminance=0.1f+tex2D(GlobLumColor,IN.Tex3);
	 Scene=lerp(Scene,Bloom,lerpFac)*(1/Luminance);
	#endif
	#if vignette == 1
	 Scene *=1-saturate(dot(IN.Tex1-0.5,IN.Tex1-0.5));
	#endif
	return float4((Scene*ScreenColor)+(mul(GrayColor,Scene).xyz*Gray)+(mul(SepiaColor,Scene).xyz*Sepia),1);
     }

//--------------
// techniques   
//--------------
    technique Frame
      {
 	pass p1
      {		
 	VertexShader = compile vs_2_0 VS(); 
 	PixelShader  = compile ps_2_0 PS(); 	
	AlphaBlendEnable=true;
	SrcBlend=SRCALPHA;
	DestBlend=INVSRCALPHA;
	zwriteenable=false;
	zenable=false;	 	
      }
      }
