//====================================================
// Luminance Filter 3
//====================================================
// By EVOLVED
// www.evolved-software.com
//====================================================

//--------------
// tweaks
//--------------
   float2 ViewVec;
   float2 DownFilteroffset[9]={{-1,-1},{-1,1},{1,-1},{1,1},{-0.5,0},{0,-0.5},{0,0.5},{0.5,0},{0,0}};

//--------------
// Textures
//--------------
   texture ColorsampleTX <string Name = " ";>;
   sampler Colorsample=sampler_state 
      {
	Texture=<ColorsampleTX>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 OPos:POSITION; 
 	float2 Tex:TEXCOORD0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.OPos=IN.Pos; 
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewVec;
	return OUT;
    }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
	float DownCol=0;
 	for (int i = 0; i < 9; i++) DownCol +=tex2D(Colorsample,IN.Tex+(DownFilteroffset[i]*0.3f));
	return float4((DownCol/9).xxx/0.8,0.08f);		
     }  

//--------------
// techniques   
//--------------
    technique DownFilter
      {
 	pass p1
      {		
 	VertexShader = compile vs_2_0 VS(); 
 	PixelShader  = compile ps_2_0 PS();
	AlphaBlendEnable=true;
	SrcBlend=SRCALPHA;
	DestBlend=INVSRCALPHA;
	zwriteenable=false;
	zenable=false;		
      }
      }
