//====================================================
// Sky Box
//====================================================
// By EVOLVED
// www.evolved-software.com
//====================================================

//--------------
// un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;   
   matrix ViewInv:ViewInverse; 
   matrix SunProjMatrix;
   matrix PreviousVP;
   float NearFocus=50.0f;
   float FarFocus=2500.0f;
   matrix ProjMat={0.5,0,0,0.5,0,-0.5,0,0.5,0,0,0.5,0.5,0,0,0,1};

//--------------
// Textures
//--------------
   texture cubeMapTX : ENVIRONMENT <string Name = "";  >;
   samplerCUBE cubeMap = sampler_state 
      {
	Texture = <cubeMapTX>;
      };
   texture SunColorTX <string Name = " ";>;
   sampler SunColor=sampler_state 
      {
	Texture=<SunColorTX>;
     	ADDRESSU=BORDER;
        ADDRESSV=BORDER;
        ADDRESSW=BORDER;
      };

//--------------
// structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION;
 	float2 UV:TEXCOORD;
     };
   struct output
     {
 	float4 OPos:POSITION;
 	float3 View:TEXCOORD0;
 	float4 SunProj:TEXCOORD1;
     };
   struct IN_Velocity
       {
        float4 Pos:POSITION;
       };
   struct OUT_Velocity
       {
 	float4 OPos:POSITION; 
    	float4 CurrentPos:TEXCOORD0; 
    	float4 PreviousPos:TEXCOORD1; 
     	float Depth:TEXCOORD2;
       };

//--------------
// vertex shader
//--------------
   output VS(input IN) 
    {
 	output OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
	OUT.View=(mul(IN.Pos,World)-ViewInv[3].xyz); 
	OUT.SunProj=mul(ProjMat,mul(IN.Pos,SunProjMatrix));
	return OUT;
    }
   OUT_Velocity VS_Velocity(IN_Velocity IN) 
    {
 	OUT_Velocity OUT;
	OUT.OPos=mul(IN.Pos,WorldVP);
 	OUT.CurrentPos=mul(IN.Pos,WorldVP);
	OUT.PreviousPos=mul(mul(IN.Pos,World),PreviousVP);
        OUT.Depth=OUT.OPos.z; 
	return OUT;
    }

//--------------
// pixel shader
//--------------
    float4 PS(output IN)  : COLOR
     {		
	return texCUBE(cubeMap,IN.View);
     }
    float4 PS_Velocity(OUT_Velocity IN)  : COLOR
     {		
   	float2 velocity=((IN.CurrentPos/IN.CurrentPos.w)-(IN.PreviousPos/IN.PreviousPos.w));
        float CloseDepth=saturate(1-(IN.Depth/NearFocus));	
        float FarDepth=CloseDepth+saturate((-NearFocus+IN.Depth)/FarFocus);	
	return float4(velocity,FarDepth,1);
     }
    float4 PS_Sun(output IN)  : COLOR
     {		
	return float4(0.15f+tex2Dproj(SunColor,IN.SunProj).xyz,0);
     }

//--------------
// techniques   
//--------------
    technique Sky
      {
 	pass p1
      {		
 	vertexShader = compile vs_1_0 VS(); 
 	pixelShader  = compile ps_1_0 PS();	
      }
      }
    technique VelocityDOF
      {
 	pass p1
      {		
 	vertexShader = compile vs_2_0 VS_Velocity(); 
 	pixelShader  = compile ps_2_0 PS_Velocity();	
      }
      }    
    technique Black
      {
 	pass p1
      {		
 	vertexShader = compile vs_1_0 VS(); 
 	pixelShader  = compile ps_1_4 PS_Sun();	
      }
      }
