//====================================================
// Diffuse Lighting for jGfx Geometry Instancing
//====================================================
//
// Includes second texture stage and vertex diffuse color
//

//--------------
// Un-tweaks
//--------------
   matrix ViewProj:ViewProjection;

//--------------
// Tweaks
//--------------
   float3 Ambient={0.2f,0.2f,0.2f};
   float3 LightColor={1.0f,1.0f,1.0f};
   float3 LightDir={0.5f,-0.5f,-0.5f};

//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler2D Base = sampler_state 
    {
 	texture = <BaseTX>;
	Mipfilter = Anisotropic;
	Minfilter = Anisotropic;
	Magfilter = Anisotropic;
   	AddressU = Wrap;
   	AddressV = Wrap;
   	AddressW = Wrap;
    };

//--------------
// structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION; 
	float3 Normal:NORMAL;
	float4 VDiff:COLOR0;   //vertex diffuse color
 	float2 UV:TEXCOORD0; 
 	float2 UV1:TEXCOORD1;  //second texture stage
	float4 WorldRow1:TEXCOORD2;
	float4 WorldRow2:TEXCOORD3;
	float4 WorldRow3:TEXCOORD4;
	float4 WorldRow4:TEXCOORD5;
     };
   struct output
     {
	float4 OPos:POSITION; 
 	float2 Tex:TEXCOORD0; 
	float3 WNormal:TEXCOORD1;
        float4 VtxDiff:TEXCOORD2;
     };

//--------------
// vertex shader
//--------------
   output VS(input IN) 
     {
 	output OUT;
	//construct the world matrix from vertex data
	matrix World = float4x4(IN.WorldRow1, IN.WorldRow2, IN.WorldRow3, IN.WorldRow4);
	OUT.OPos=mul(IN.Pos,mul(World,ViewProj)); 
 	OUT.Tex=IN.UV*IN.UV1;				//Scale UV using UV1
	OUT.WNormal=normalize(mul(IN.Normal,World));
	OUT.VtxDiff = IN.VDiff; 			//Pass vertex diffuse to PixelShader
	return OUT;
     }

//--------------
// pixel shader
//--------------
    float4 PS(output IN)  : COLOR
     {
	float4 Texture=tex2D(Base,IN.Tex); 
	float Light=saturate(dot(IN.WNormal,normalize(-LightDir)));
	return Texture*IN.VtxDiff*float4(Light+Ambient,1.0f);
     }

//--------------
// techniques   
//--------------
   technique Diffuse
      {
 	pass p1
      {		
 	vertexShader = compile vs_2_0 VS(); 
 	pixelShader  = compile ps_2_0 PS();
      }
      }