//====================================================
// Normal Mapping for jGfx Geometry Instancing
//====================================================

//--------------
// Un-tweaks
//--------------
   matrix ViewProj:ViewProjection;

//--------------
// Tweaks
//--------------
   float3 Ambient={0.2f,0.2f,0.2f};
   float3 LightColor={1.0f,1.0f,1.0f};
   float3 LightDir={0.5f,-0.5f,-0.5f};

//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler2D Base = sampler_state 
      {
     	texture = <BaseTX>;
	Mipfilter = Anisotropic;
	Minfilter = Anisotropic;
	Magfilter = Anisotropic;
   	AddressU = Wrap;
   	AddressV = Wrap;
   	AddressW = Wrap;
      };
   texture NormalTX <string Name="";>;	
   sampler2D Normal = sampler_state 
      {
 	texture = <NormalTX>;
	Mipfilter = Anisotropic;
	Minfilter = Anisotropic;
	Magfilter = Anisotropic;
   	AddressU = Wrap;
   	AddressV = Wrap;
   	AddressW = Wrap;
      };

//--------------
// structs 
//--------------
   struct input
       {
 	float4 Pos:POSITION;
    	float2 UV:TEXCOORD0; 
	float3 Normal:NORMAL;
 	float3 Tangent:TANGENT;
 	float3 Binormal:BINORMAL;
	float4 WorldRow1:TEXCOORD1;
	float4 WorldRow2:TEXCOORD2;
	float4 WorldRow3:TEXCOORD3;
	float4 WorldRow4:TEXCOORD4;
       };
   struct output
       {
 	float4 OPos:POSITION; 
    	float2 Tex:TEXCOORD0; 
  	float3 TbnRow1:TEXCOORD1; 
  	float3 TbnRow2:TEXCOORD2; 
  	float3 TbnRow3:TEXCOORD3;
       };

//--------------
// vertex shader
//--------------
   output VS(input IN) 
    {
 	output OUT;
	//construct the world matrix from vertex data
	matrix matWorld = float4x4(IN.WorldRow1, IN.WorldRow2, IN.WorldRow3, IN.WorldRow4);
	OUT.OPos=mul(IN.Pos,mul(matWorld,ViewProj)); 
 	OUT.Tex=IN.UV;
	float3 WPos=mul(IN.Pos,matWorld);
	float3x3 TBN={IN.Tangent,IN.Binormal,IN.Normal};
	TBN=mul(TBN,matWorld);
	OUT.TbnRow1=TBN[0];
	OUT.TbnRow2=TBN[1];
	OUT.TbnRow3=TBN[2];
	return OUT;
    }

//--------------
// pixel shader
//--------------
    float4 PS(output IN)  : COLOR
     {		
  	float3 Texture=tex2D(Base,IN.Tex);
	float3 NormalMap=normalize(tex2D(Normal,IN.Tex)*2-1); 
	float3 WNorm = normalize(mul(tex2D(Normal,IN.Tex)*2-1,float3x3(IN.TbnRow1,IN.TbnRow2,IN.TbnRow3)));
	float Light=saturate(dot(normalize(-LightDir),WNorm));
	return float4(Texture*((Light*LightColor)+Ambient),1.0f);
     }

//--------------
// techniques   
//--------------
    technique Normalmap
      {
 	pass p1
      {		
 	vertexShader = compile vs_2_0 VS(); 
 	pixelShader  = compile ps_2_0 PS();
      }
      }
