// Object Diffuse Shader for MRT Deferred shading example

//--------------
// Un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;   
   matrix ViewInv:ViewInverse;

//--------------
// Textures
//--------------
   texture BaseTX <string Name="";>;	
   sampler2D Base = sampler_state 
    {
 	texture = <BaseTX>;
	Mipfilter = Anisotropic;
	Minfilter = Anisotropic;
	Magfilter = Anisotropic;
    };

//--------------
// Structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION; 
	float3 Normal:NORMAL;
 	float2 UV:TEXCOORD0; 
     };
   struct output
     {
	float4 OPos:POSITION;
 	float2 Tex:TEXCOORD0;
	float3 WNormal:TEXCOORD1;
  	float3 WPos:TEXCOORD2;
     };


//Output structure for MRT pixel shader
   struct outputMRT
     {
	float4 Col0:COLOR0; 
	float4 Col1:COLOR1; 
	float4 Col2:COLOR2; 
     };

//--------------
// Vertex Shader
//--------------
   output VS(input IN) 
     {
 	output OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 
 	OUT.Tex=IN.UV+0.05;
	OUT.WNormal=normalize(mul(IN.Normal,World));
	OUT.WPos=mul(IN.Pos,World)-ViewInv[3].xyz;
	return OUT;
     }

//--------------
// Pixel Shader
//--------------

    outputMRT PS(output IN)
     {
	outputMRT OUT;

	OUT.Col0 = float4(IN.WPos,length(IN.WPos));
	OUT.Col1 = float4((IN.WNormal+1.0)*0.5,1.0f);
	OUT.Col2 = tex2D(Base,IN.Tex);

	return OUT;
     }


//--------------
// Techniques   
//--------------
   technique GBufferMRT
      {
 	pass p1
      {		
 	vertexShader = compile vs_3_0 VS(); 
 	pixelShader  = compile ps_3_0 PS();
      }
      }