// Final Compisition Shader for MRT Deferred Shading Example

//--------------
// Un-tweaks
//--------------
   matrix ViewInv:ViewInverse;

//--------------
// Tweaks
//--------------
   float4 FogColor={0.0f,0.0f,0.0f,1.0f};
   float FogRange=10000.0f;

//--------------
// Textures
//--------------
   texture WPositionTX <string Name="";>;	
   sampler2D WPosition = sampler_state 
    {
 	texture = <WPositionTX>;
	Mipfilter = Point;
	Minfilter = Point;
	Magfilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
    };

   texture WNormalTX <string Name="";>;	
   sampler2D WNormals = sampler_state 
    {
 	texture = <WNormalTX>;
	Mipfilter = Point;
	Minfilter = Point;
	Magfilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
    };


   texture DiffuseTX <string Name="";>;	
   sampler2D Diffuse = sampler_state 
    {
 	texture = <DiffuseTX>;
	Mipfilter = Point;
	Minfilter = Point;
	Magfilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
    };

   texture LightingTX <string Name="";>;	
   sampler2D Lighting = sampler_state 
    {
 	texture = <LightingTX>;
	Mipfilter = Point;
	Minfilter = Point;
	Magfilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
    };


//--------------
// Structs 
//--------------

   struct input
     {
 	float4 Pos:POSITION; 
 	float2 UV:TEXCOORD0; 
     };
   struct output
     {
	float4 OPos:POSITION;
 	float2 Tex:TEXCOORD0;
     };


//--------------
// Vertex Shader
//--------------

   output VS(input IN) 
     {
 	output OUT;
	OUT.OPos=float4(IN.Pos.xy,0,1); 
 	OUT.Tex=IN.UV;
	return OUT;
     }

//--------------
// Pixel Shader
//--------------
    float4 PS(output IN) : COLOR
     {
	float Depth = tex2D(WPosition,IN.Tex).w;
	clip(Depth-0.01);	
	float3 WNorm=normalize(tex2D(WNormals,IN.Tex)*2-1);
	float4 Texture=tex2D(Diffuse,IN.Tex);
	float3 Light=tex2D(Lighting,IN.Tex);
	return float4(lerp(Texture*Light,FogColor,Depth/FogRange),1.0f);
     }

//--------------
// Techniques   
//--------------
   technique Final
      {
 	pass p1
      {		
 	vertexShader = compile vs_3_0 VS(); 
 	pixelShader  = compile ps_3_0 PS();
      }
      }