// PointLight Shader for MRT Deferred shading example

//--------------
// Un-tweaks
//--------------
   matrix WorldVP:WorldViewProjection; 
   matrix World:World;    
   matrix ViewInv:ViewInverse; 

//--------------
// Tweaks
//--------------
   float3 LightColor={1.0f,1.0f,1.0f};      
   float ProjShift=0.05f;

//--------------
// Textures
//--------------
   texture WorldPosTX <string Name = "";>; 
   sampler WorldPos=sampler_state 
      {
	Texture=<WorldPosTX>;
	Mipfilter = Point;
	Minfilter = Point;
	Magfilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
      };
   texture WorldNormalsTX <string Name = "";>; 
   sampler WorldNormals=sampler_state 
      {
	Texture=<WorldNormalsTX>;
	Mipfilter = Point;
	Minfilter = Point;
	Magfilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
      };

//--------------
// Structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION;  	
     };
   struct output
     {
	float4 OPos:POSITION; 
 	float4 Proj:TEXCOORD0;
	float Range:TEXCOORD1;
     };

//--------------
// Vertex Shader
//--------------
   output VS(input IN) 
     {
 	output OUT;
	OUT.OPos=mul(IN.Pos,WorldVP); 	
	OUT.Proj=float4(OUT.OPos.x*0.5+0.5*OUT.OPos.w,0.5*OUT.OPos.w-OUT.OPos.y*0.5,OUT.OPos.w,OUT.OPos.w)+float4(ProjShift,ProjShift,0,0);
	OUT.Range = length(World[0].xyz)*100.0;
	return OUT;
    }

//--------------
// Pixel Shader
//--------------
   float4 PS(output IN) : COLOR
     {
	float4 WPos=tex2Dproj(WorldPos,IN.Proj);
	clip(WPos.w-0.1);
	float3 LightV=(WPos.xyz+ViewInv[3].xyz)-World[3].xyz;
	float3 WNormals=tex2Dproj(WorldNormals,IN.Proj)*2-1;
	float Normal=saturate(dot(WNormals,normalize(-LightV)));
	Normal *= (1.0-saturate(length(LightV/IN.Range)));
	return float4(Normal*LightColor,1);
     } 

//--------------
// Techniques   
//--------------
    technique PointLight
      {
  	pass p1
      {		
  	vertexShader = compile vs_2_0 VS(); 
  	pixelShader  = compile ps_2_0 PS(); 	
	AlphaBlendEnable = True;
 	SrcBlend = One;
 	DestBlend = One;
	ZEnable = False;
	ZWriteEnable = False;
      }
      }