// PointLight Batch Shader for MRT Deferred shading example

//--------------
// Un-tweaks
//--------------
   matrix VProj:ViewProjection; 
   matrix World:World;    
   matrix ViewInv:ViewInverse; 

//--------------
// Tweaks
//--------------
   float ProjShift=0.05f;

//--------------
// Textures
//--------------
   texture WorldPosTX <string Name = "";>; 
   sampler WorldPos=sampler_state 
      {
	Texture=<WorldPosTX>;
	Mipfilter = Point;
	Minfilter = Point;
	Magfilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
      };
   texture WorldNormalsTX <string Name = "";>; 
   sampler WorldNormals=sampler_state 
      {
	Texture=<WorldNormalsTX>;
	Mipfilter = Point;
	Minfilter = Point;
	Magfilter = Point;
	AddressU = Clamp;
	AddressV = Clamp;
	AddressW = Clamp;
      };

//--------------
// Structs 
//--------------
   struct input
     {
 	float4 Pos:POSITION; 
	float2 UV0:TEXCOORD0;
	float2 UV1:TEXCOORD1;
	float4 Diffuse:COLOR;
     };
   struct output
     {
	float4 OPos:POSITION; 
 	float4 Proj:TEXCOORD0;
	float3 LPos:TEXCOORD1;
	float Range:TEXCOORD2;
	float4 LCol:TEXCOORD3;
     };

//--------------
// Vertex Shader
//--------------
   output VS(input IN) 
     {
 	output OUT;
	OUT.OPos=mul(IN.Pos,VProj); 	
	OUT.Proj=float4(OUT.OPos.x*0.5+0.5*OUT.OPos.w,0.5*OUT.OPos.w-OUT.OPos.y*0.5,OUT.OPos.w,OUT.OPos.w)+float4(ProjShift,ProjShift,0,0);
	OUT.LPos = float3(IN.UV0.xy, IN.UV1.x);
	OUT.Range = IN.UV1.y;
	OUT.LCol = IN.Diffuse;
	return OUT;
    }

//--------------
// Pixel Shader
//--------------
   float4 PS(output IN) : COLOR
     {
	float3 WPos=tex2Dproj(WorldPos,IN.Proj);
	clip(length(WPos)-0.1);
	float3 LightV=(WPos+ViewInv[3].xyz)-IN.LPos;
	float3 WNormals=normalize(tex2Dproj(WorldNormals,IN.Proj)*2-1);
	float Normal=saturate(dot(WNormals,normalize(-LightV)));
	Normal *= (1.0-saturate(length(LightV/IN.Range)));
	return float4(IN.LCol.xyz*Normal,1);
     } 

//--------------
// Techniques   
//--------------
    technique PointLight
      {
  	pass p1
      {		
  	vertexShader = compile vs_2_0 VS(); 
  	pixelShader  = compile ps_2_0 PS(); 	
	AlphaBlendEnable = True;
 	SrcBlend = One;
 	DestBlend = One;
	BlendOp = Add;
	ZEnable = False;
	ZWriteEnable = False;
      }
      }