  float4 ReflectionOffset[7]={float4(0.5,0.0009765625-0.00130208333,0.25,0.66764322916-0.00130208333),
                              float4(0.25,0.66764322916-0.00130208333,0.625,0.66764322916-0.00130208333),
                              float4(0.625,0.66764322916-0.00130208333,0.8125,0.66764322916-0.00130208333),
                              float4(0.8125,0.66764322916-0.00130208333,0.90625,0.66764322916-0.00130208333),
                              float4(0.90625,0.66764322916-0.00130208333,0.953125,0.66764322916-0.00130208333),
                              float4(0.953125,0.66764322916-0.00130208333,0.9765625,0.66764322916-0.00130208333),
                              float4(0.9765625,0.66764322916-0.00130208333,0.97265625,0.66764322916-0.00130208333)};
  float4 ReflectionSize[7]={float4(0.498046875,0.6640625,0.248046875,0.33072916666),
                            float4(0.248046875,0.33072916666,0.123046875,0.1640625),
                            float4(0.123046875,0.1640625,0.060546875,0.08072916666),
                            float4(0.060546875,0.08072916666,0.029296875,0.0390625),
                            float4(0.029296875,0.0390625,0.013671875,0.01822916666),
                            float4(0.013671875,0.01822916666,0.005859375,0.0078125),
                            float4(0.005859375,0.0078125,0.001953125,0.00260416666)}; 
  float3 Reflections(in float3 ReflectionVec, in float Roughness, in float ReflectionId)
      {
         float2 Equirectangular=0.3183*float2(atan2(-ReflectionVec.z,ReflectionVec.x),acos(ReflectionVec.y));
         int Levels=clamp(floor(Roughness*6.0),0.0,6.0);
         float4 Tex=ReflectionOffset[Levels]+Equirectangular.xyxy*ReflectionSize[Levels];
         float4 Reflect=lerp(tex3Dlod(LightSampler,float4(Tex.xy,ReflectionId,0.0)),tex3Dlod(LightSampler,float4(Tex.zw,ReflectionId,0.0)),frac(Roughness*6.0));
         return Reflect.xyz*pow(1.04,Reflect.w*255.0-128.0);
      }