// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------
   float2 ViewSize;

//--------------
// Textures
//--------------
   texture Face1Texture <string Name = " ";>;
   sampler Face1Sampler=sampler_state 
      {
         Texture=<Face1Texture>;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
         ADDRESSW=CLAMP;
         MipFilter=None;
         MagFilter=None;
         MinFilter=None;
      };
   texture Face2Texture <string Name = " ";>;
   sampler Face2Sampler=sampler_state 
      {
         Texture=<Face2Texture>;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
         ADDRESSW=CLAMP;
         MipFilter=None;
         MagFilter=None;
         MinFilter=None;
      };
   texture Face3Texture <string Name = " ";>;
   sampler Face3Sampler=sampler_state 
      {
         Texture=<Face3Texture>;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
         ADDRESSW=CLAMP;
         MipFilter=None;
         MagFilter=None;
         MinFilter=None;
      };
   texture Face4Texture <string Name = " ";>;
   sampler Face4Sampler=sampler_state 
      {
         Texture=<Face4Texture>;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
         ADDRESSW=CLAMP;
         MipFilter=None;
         MagFilter=None;
         MinFilter=None;
      };
   texture Face5Texture <string Name = " ";>;
   sampler Face5Sampler=sampler_state 
      {
         Texture=<Face5Texture>;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
         ADDRESSW=CLAMP;
         MipFilter=None;
         MagFilter=None;
         MinFilter=None;
      };
   texture Face6Texture <string Name = " ";>;
   sampler Face6Sampler=sampler_state 
      {
         Texture=<Face6Texture>;
         ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
         ADDRESSW=CLAMP;
         MipFilter=None;
         MagFilter=None;
         MinFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
         float4 Pos:POSITION; 
     };
   struct OutPut
     {
         float4 Pos:POSITION; 
         float2 Tex:TEXCOORD0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN)
     {
         OutPut OUT;
         OUT.Pos=IN.Pos;
         OUT.Tex=((float2(IN.Pos.x,IN.Pos.y)+1.0)*0.5)+ViewSize;
         return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN)  : COLOR
      {
         float3 EqVec=0;
         EqVec.x=cos(IN.Tex.x*6.2831852);
         EqVec.y=(1.0-IN.Tex.y)*2.0-1.0;
         EqVec.z=sin(IN.Tex.x*6.2831852);
         EqVec.y=tan(EqVec.y*1.5707963);
         EqVec=normalize(float3(-EqVec.x,EqVec.y,EqVec.z));
         float3 CubeFace=abs(EqVec);
         CubeFace=sign(EqVec)*saturate(1.0-floor(max(CubeFace.zxx,CubeFace.yzy)/CubeFace.xyz));
         float3 CubePos=max(CubeFace,0.0);
         float3 CubeNeg=max(-CubeFace,0.0);
         float2 UvX=(float2(-EqVec.z,EqVec.y*-CubeFace.x)/EqVec.x)*0.5+0.5;
         float2 UvY=(float2(EqVec.x*CubeFace.y,EqVec.z)/EqVec.y)*0.5+0.5;
         float2 UvZ=(float2(EqVec.x,EqVec.y*-CubeFace.z)/EqVec.z)*0.5+0.5;
         float3 Reflections=tex2Dlod(Face1Sampler,float4(UvX,0.0,0.0))*CubePos.x+tex2Dlod(Face3Sampler,float4(UvY,0.0,0.0))*CubePos.y
                           +tex2Dlod(Face5Sampler,float4(UvZ,0.0,0.0))*CubePos.z+tex2Dlod(Face2Sampler,float4(UvX,0.0,0.0))*CubeNeg.x
                           +tex2Dlod(Face4Sampler,float4(UvY,0.0,0.0))*CubeNeg.y+tex2Dlod(Face6Sampler,float4(UvZ,0.0,0.0))*CubeNeg.z;
         return float4(Reflections,1.0);
      }

//--------------
// techniques   
//--------------
   technique Equirectangular
      {
         pass p1
      {	
         VertexShader = compile vs_3_0 VS();
         PixelShader  = compile ps_3_0 PS(); 
      }
      }
