// By EVOLVED
// www.evolved-software.com

#include "Settings.fx"

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 View:View;
   float4x4 Project:Projection;
   float4x4 ViewProj:ViewProjection; 
   float4x4 ViewInv:ViewInverse;

//--------------
// tweaks
//--------------
   float4 ViewSize;
   float4 FogColor;
   float3 FogDensity;
   float4 FogHeight;
   float4 FogHeightColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float SkyIntensity;
   float Density;
   float3 SkyColor;
   float4 SkyTotal;
   float4 NightColor;
   float3 SunDirection;
   float3 SunScale;
   float SunIntensity;
   float4 AbsorptionSun;
   float3 LightColor1;
   float3 LightColor2;
   float3 CloudColor;
   float2 CloudScale;
   float3 CloudCover;
   float4x4 MoonProj;
   float3x3 StarsAngle;
   float4 SamplesOffset[9]={float4(-1.0,-1.0,0.0,0.0),
	                     float4(0.0,-1.0,0.0,0.0),
	                     float4(1.0,-1.0,0.0,0.0),
	                     float4(-1.0,0.0,0.0,0.0),
	                     float4(0.0,0.0,0.0,0.0),
	                     float4(1.0,0.0,0.0,0.0),
	                     float4(-1.0,1.0,0.0,0.0),
	                     float4(0.0,1.0,0.0,0.0),
	                     float4(1.0,1.0,0.0,0.0)};

//--------------
// Textures
//--------------
   texture CloudTexture <string Name=""; >;
   sampler CloudSampler=sampler_state 
      {
         Texture=<CloudTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
      };
   texture MoonTexture <string Name = "";>;      
   sampler MoonSampler=sampler_state
      {
         texture=<MoonTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
         AddressU=Border;
         AddressV=Border;
      };
   texture StarsTexture <string Name="";>;
   sampler StarsSampler=sampler_state
      {
         texture=<StarsTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=Linear;
      };
   texture CloudVolumetricTexture <string Name=""; >;
   sampler CloudVolumetricSampler=sampler_state 
      {
         Texture=<CloudVolumetricTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         AddressU=Clamp;
         AddressV=Clamp;
      };
   texture DepthTexture <string Name = "";>;         
   sampler DepthSampler=sampler_state 
      {
         Texture=<DepthTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         AddressU=Clamp;
         AddressV=Clamp;
      };
   texture SSAOTexture <string Name = " ";>;
   sampler SSAOSampler=sampler_state 
      {
         Texture=<SSAOTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         AddressU=Clamp;
         AddressV=Clamp;
      };

//--------------
// structs 
//--------------
   struct Input
      {
         float4 Pos:POSITION;
      };
   struct Output
      {
         float4 Pos:POSITION; 
         float4 Project:TEXCOORD0;
         float3 WorldPos:TEXCOORD1;
         float3 ViewVec:TEXCOORD2;
         float4 Moon:TEXCOORD3;
         float3 Stars:TEXCOORD4;
      };

//--------------
// vertex shader
//--------------
   Output VS(Input IN) 
      {
         Output OUT;
         float3 WorldPos=mul(IN.Pos,World);
         OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
         OUT.Project=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z*0.5,OUT.Pos.w);
         OUT.WorldPos=WorldPos;
         float3 ViewVec=WorldPos-ViewInv[3].xyz;
         OUT.ViewVec=ViewVec;
         float4 MoonProj=mul(float4(ViewVec,1.0),MoonProj);
         OUT.Moon=float4(MoonProj.x*0.5+0.5*MoonProj.w,0.5*MoonProj.w-MoonProj.y*0.5,MoonProj.z,MoonProj.w);
         OUT.Stars=mul(IN.Pos,StarsAngle);
         return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting1(Output IN) : COLOR
      {
         return float4(0.0,0.0,0.0,64000.0);
      }
   float4 PS_Lighting2(Output IN) : COLOR
      {
         IN.Project.xy /=IN.Project.w;
         float3 Normals=normalize(float3(IN.ViewVec.x,IN.WorldPos.y,IN.ViewVec.z));
         float2 CloudUv=(IN.ViewVec.xz/IN.ViewVec.y)/CloudScale;
         float Clouds=tex2Dlod(CloudSampler,CloudUv.xyyy).x*tex2Dlod(CloudSampler,CloudUv.xyyy*0.1).y*max(Normals.y,0.0);
         float4 Moon=tex2Dlod(MoonSampler,IN.Moon/IN.Moon.w)*saturate(IN.Moon.z);
         float3 Stars=texCUBE(StarsSampler,IN.Stars)+(NightColor.xyz*0.4);
         float SunDir=length(Normals-SunDirection);
         float Horizon=1.0-saturate(exp(-Normals.y*25.0));
         float Zenith=Density/pow(max(Normals.y,0.0035),0.75);
         float3 Absorption=exp2(SkyColor*-Zenith);
         float Rayleigh=1.0+(1.0-(0.5+SunDir*0.5))*1.5707963268;
         float3 Sky=SkyColor*Rayleigh*Zenith;
         float3 Sun=SunIntensity*Absorption*smoothstep(SunScale.x,SunScale.y,SunDir)*SunScale.z*Horizon*(1.0-Moon.w);
         float Disk=saturate(1.0-pow(SunDir,0.1));
         float3 Mie=AbsorptionSun.xyz*Disk*Disk*(3.0-2.0*Disk)*3.14159265359;
         Sky=(SkyTotal*(lerp(Sky*Absorption,Sky/(Sky+0.25),AbsorptionSun.w)+Mie+Sun));
         Sky +=pow(lerp(Stars,Moon.xyz,Moon.w),2.2)*max(Normals.y*2,0.0)*(1.0-SkyTotal.w*0.95);
         float4 CloudColors=lerp(NightColor,AbsorptionSun,SkyTotal.w);
         float3 CloudVolumetric=pow(tex2Dlod(CloudVolumetricSampler,IN.Project+ViewSize),2.0);
         CloudVolumetric.z=saturate(1.12*CloudVolumetric.z);
         Sky=lerp(Sky*0.5,LightColor2,Clouds*0.5)*(1.0-CloudVolumetric.z);
         Sky +=CloudColor*CloudVolumetric.z+LightColor1*CloudVolumetric.y+LightColor2*pow(CloudVolumetric.x,3.0);
         float3 Fog=lerp(FogColor.xyz,LightDirectionColor*0.5,pow(max(dot(normalize(IN.ViewVec),LightDirection),0.0),2.0));
         float FogDist=1.0-saturate((IN.WorldPos.y-CloudCover.x)/CloudCover.y);
         Sky=lerp(SkyIntensity*Sky,Fog,FogDist*FogDist*CloudCover.z);
         FogDist=1.0-saturate((IN.WorldPos.y-FogHeight.x)/FogHeight.z);
         return float4(lerp(Sky,Fog,FogDist*FogDist),64000.0);
      }
   float4 PS_Distortion1(Output IN) : COLOR
      {
         IN.Project.xy=(IN.Project.xy/IN.Project.w)+ViewSize;
         float Depth=tex2Dlod(DepthSampler,IN.Project).w;
         float SSAOBlur=9.0;
         #if SSAO ==1
          SSAOBlur=0.0;
          float2 Offset=ViewSize*(4.0+(16.0/(1.0+(Depth*0.01))));
          for (int i = 0; i < 9; i++) SSAOBlur +=tex2Dlod(SSAOSampler,IN.Project+SamplesOffset[i]*Offset.xyyy).w;
         #endif
         return float4(0.5,0.5,0.0,SSAOBlur*0.111111);
      }
   float4 PS_Distortion2(Output IN) : COLOR
      {
         IN.Project.xy=(IN.Project.xy/IN.Project.w)+ViewSize;
         float Depth=tex2Dlod(DepthSampler,IN.Project).w;
         float3 Normals=normalize(float3(IN.ViewVec.x,IN.WorldPos.y,IN.ViewVec.z));
         float Light=max(dot(SunDirection,Normals),0.0);
         Light=1.0-(0.2+pow(Light,16.0)*0.8);
         Light=lerp(Light,1.0,tex2Dlod(CloudVolumetricSampler,IN.Project).z);
         if(Depth<64000.0) Light=1.0;
         float SSAOBlur=9.0;
         #if SSAO ==1
          SSAOBlur=0.0;
          float2 Offset=ViewSize*(4.0+(16.0/(1.0+(Depth*0.01))));
          for (int i = 0; i < 9; i++) SSAOBlur +=tex2Dlod(SSAOSampler,IN.Project+SamplesOffset[i]*Offset.xyyy).w;
         #endif
         return float4(0.50196078431,0.50196078431,Light,SSAOBlur*0.111111);
      }

//--------------
// techniques   
//-------------- 
   technique Lighting1
      {
         pass p1
      {         
         vertexShader = compile vs_3_0 VS();
         pixelShader  = compile ps_3_0 PS_Lighting1();
         ColorWriteEnable=8;
         zwriteenable=false;
         CullMode=cw;
      }
      }
   technique Lighting2
      {
         pass p1
      {         
         vertexShader = compile vs_3_0 VS();
         pixelShader  = compile ps_3_0 PS_Lighting2();
         zwriteenable=false;
         CullMode=cw;
      }
      }
   technique Distortion1
      {
         pass p1
      {         
         vertexShader = compile vs_3_0 VS();
         pixelShader  = compile ps_3_0 PS_Distortion1();
         ColorWriteEnable=15;
         zwriteenable=false;
         CullMode=cw;
      }
      }
   technique Distortion2
      {
         pass p1
      {         
         vertexShader = compile vs_3_0 VS();
         pixelShader  = compile ps_3_0 PS_Distortion2();
         ColorWriteEnable=15;
         zwriteenable=false;
         CullMode=cw;
      }
      }