// By EVOLVED
// www.evolved-software.com

#include "settings.fx"

//--------------
// un-tweaks
//--------------
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 World:World;   
   float4x4 ViewInv:ViewInverse;
   float4x4 ViewProj:ViewProjection;

//--------------
// tweaks
//--------------
   float4 CameraPosition;
   float4 FogColor;
   float3 FogDensity;
   float4 FogHeight;
   float4 FogHeightColor;
   float3 AmbientSky;
   float3 AmbientGround;
   float3 LightingRange;
   float3 LightingTexture;
   float3 ReflectionColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float4 ShadowNoise;
   float4 ShadowBlur;
   float3 ShadowBlurSplit;
   float4x4 ShadowProj;
   float3 ShadowDirection;
   float4 ShadowPosition;
   float4 ShadowRanges;
   float4x4 ShadowProjection;
   float3 ShadowProjPos1;
   float3 ShadowProjPos2;
   float3 ShadowProjPos3;
   float3 ShadowPositionX;
   float3 ShadowPositionY;
   float3 ShadowPositionZ;
   float4x4 VarianceShadowProjection;
   float3 VarianceShadowPosition;
   float4 VariancePosition;
   float Normalz;
   float Heightvec=0.025;
   float4 TerrainSize;
   float4 TerrainTileSize;
   float TerrainHeight;
   float TextureSize;
   float TextureLayers;
   float2 TextureNoise={0.001,0.0005};
   float4 TerrainPosition[6];
   float4 SamplesSize[8];
   float4 SamplesOffset[8];
   float SlopeTexture;
   float SlopeSize;
   float SlopeMin;
   float SlopeBlend;

//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;
   sampler BaseSampler=sampler_state
      {
         Texture=<BaseTexture>;
  	 MagFilter=anisotropic;
	 MinFilter=anisotropic;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture NormalMapTexture <string Name = "";>;
   sampler NormalMapSampler=sampler_state
      {
 	 Texture=<NormalMapTexture>;
  	 MagFilter=anisotropic;
	 MinFilter=anisotropic;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture TerrainTexture <string Name = "";>;	
   sampler TerrainSampler=sampler_state 
      {
         Texture=<TerrainTexture>;
         MipFilter=None;
         MinFilter=None;
         MagFilter=None;
	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture LightTexture <string Name="";>;
   sampler LightSampler=sampler_state
      {
	 Texture=<LightTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      };
   texture LightDataTexture <string Name = "";>;
   sampler LightDataSampler=sampler_state
      {
 	 Texture=<LightDataTexture>;
  	 MagFilter=None;
	 MinFilter=None;
	 MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow1Texture <string Name = "";>;
   sampler Shadow1Sampler=sampler_state
      {
 	 Texture=<Shadow1Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         AddressU=Border;
         AddressV=Border;
         AddressW=Border;
         BorderColor=16646655;
      };
   texture Shadow2Texture <string Name = "";>;
   sampler Shadow2Sampler=sampler_state
      {
 	 Texture=<Shadow2Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow3Texture <string Name = "";>;
   sampler Shadow3Sampler=sampler_state
      {
 	 Texture=<Shadow3Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };

//--------------
// Functions
//--------------
   #include "Tile Count.fx"
   #include "Tile Array.fx"
   #include "Diffuse Light.fx"
   #include "Spot Light.fx"
   #if Specularity == 1
    #include "Specular Light.fx"
   #endif
   #include "Vertex Fog.fx"
   #include "Vertex Ambient.fx"
   #include "Reflections.fx"
   #if ShadowsSoft == 1
    #include "Shadow Mapping.fx"
   #endif
   #if TerrainShadows == 1
    #include "Variance Shadow Mapping.fx"
   #endif
   #if Shadows == 0
    #include "Pixel Lighting.fx"
   #else
    #if ShadowsSoft == 0
     #include "Pixel Lighting Shadow.fx"
    #else
     #include "Pixel Lighting Shadow Soft.fx"
    #endif
   #endif

//--------------
// structs 
//--------------
   struct Input
     {
         float4 Pos:POSITION;
         float2 Tex1:TEXCOORD0;
         float2 Tex2:TEXCOORD1;
         float2 Tex3:TEXCOORD2;
     };
   struct Out_Lighting
     {
         float4 Pos:POSITION;
         float4 Project:TEXCOORD0;
         float4 Tex1:TEXCOORD1;
         float4 Tex2:TEXCOORD2;
         float4 TBNRow1:TEXCOORD3;
         float4 TBNRow2:TEXCOORD4;
         float4 ViewVec:TEXCOORD5;
         float4 WorldPos:TEXCOORD6;
         float3 ViewNormal:TEXCOORD7;
         float4 Ambient:COLOR0;
         float3 Reflect:COLOR1;
     };
   struct Out_Depth
     {
         float4 Pos:POSITION;
         float3 Depth:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN) 
      {
         Out_Lighting OUT;
         int Index=IN.Tex1.x;
         float3 WorldPos=0.0;
         WorldPos.xz=TerrainPosition[Index].xy+IN.Pos.xz*TerrainSize.z;
         IN.Tex2=IN.Tex3.x*(IN.Tex2/TerrainSize.xy);
         float4x4 Offset=float4x4(-IN.Tex2.x,-IN.Tex2.y,0.0,0.0,-IN.Tex2.x,IN.Tex2.y,0.0,0.0,IN.Tex2.x,-IN.Tex2.y,0.0,0.0,IN.Tex2.x,IN.Tex2.y,0.0,0.0);
         float4 NewUv=float4((WorldPos.xz/TerrainTileSize.xy)+TerrainTileSize.zw,0,0);
         float4 Terrain=tex2Dlod(TerrainSampler,NewUv);     
         float Height=tex2Dlod(TerrainSampler,NewUv+Offset[0]).w+tex2Dlod(TerrainSampler,NewUv+Offset[1]).w+tex2Dlod(TerrainSampler,NewUv+Offset[2]).w+tex2Dlod(TerrainSampler,NewUv+Offset[3]).w;
         WorldPos.y=lerp(Terrain.w,Height*0.25,pow(IN.Tex1.y,5.0))*TerrainHeight;
         OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
         OUT.Project=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z,OUT.Pos.w);
         OUT.Tex1=NewUv.xyxy+float4(0.0,0.0,1.0/TerrainSize.x,1.0/TerrainSize.y)-0.5/TerrainSize.x;
         OUT.Tex2.xyz=WorldPos.xzy/TerrainSize.w;
         OUT.Tex2.y=-OUT.Tex2.y;
         float3 Normals=float3(Terrain.y,sqrt(1.0-(Terrain.y*Terrain.y)-(Terrain.z*Terrain.z)),Terrain.z);
         float3 Tangent=float3(1.0-abs(Normals.x),-Normals.x,0.0);
         OUT.TBNRow1.xyz=Tangent;
         OUT.TBNRow2.xyz=cross(Normals,Tangent);
         OUT.ViewVec.xyz=ViewInv[3].xyz-WorldPos;
         OUT.WorldPos=float4(WorldPos,0.0);
         float3x3 WorldTBN={Tangent,OUT.TBNRow2.xyz,Normals};
         OUT.ViewNormal=mul(OUT.ViewVec,transpose(WorldTBN));
         float3 ViewVec=normalize(OUT.ViewVec);
         float ViewDepth=length(OUT.ViewVec);
         OUT.Ambient.w=1.0;
         #if Shadows == 1
          #if TerrainShadows == 1
           float2 ShadowProj=float2(0.75,0.5)+mul(float4(WorldPos,1.0),VarianceShadowProjection)*float2(0.25,-0.5);
           float Depth=dot(WorldPos-VarianceShadowPosition,ShadowDirection)/ShadowRanges.w;
           float Edge=saturate(VariancePosition.w-length(WorldPos-VariancePosition.xyz));
           OUT.Ambient.w=lerp(1.0,VarianceShadowMapping(ShadowProj,saturate(Depth)),Edge);
          #endif
         #endif
         float4 WorldCamPos=OUT.WorldPos-CameraPosition;
	 float3 AmbientDir=normalize(float3(-LightDirection.x,1.0,-LightDirection.z));
         OUT.Ambient.xyz=lerp(AmbientGround,AmbientSky,0.5+dot(Normals,AmbientDir)*0.5);
         float LightSegment=clamp(floor((ViewDepth/LightingRange.z)*16.0),0.0,15.0)*0.00390625;
         int LightCount=tex2Dlod(LightDataSampler,float4(0.12890625,LightSegment,0.0,0.0));
         float4 AmbientLighting=0.0;
         for (int l=0; l < LightCount; l++) {
          AmbientLighting=max(VertexAmbient((34.0+l)*0.00390625,LightSegment,WorldCamPos),AmbientLighting);
         }
         OUT.Ambient.xyz=lerp(OUT.Ambient,AmbientLighting.xyz,AmbientLighting.w);
         OUT.Reflect.xyz=lerp(ReflectionColor,1.0,AmbientLighting.w);
         float4 Fog=VertexFog(ViewDepth,WorldPos,ViewVec,LightDirection,LightDirectionColor,FogColor,FogDensity,FogHeightColor,FogHeight);
         OUT.Tex2.w=Fog.x, OUT.TBNRow1.w=Fog.y, OUT.TBNRow2.w=Fog.z, OUT.ViewVec.w=Fog.w;
         return OUT;
      }
   Out_Depth VS_DepthMapDir(Input IN)
      {
         Out_Depth OUT;
         int Index=IN.Tex1.x;
         float3 WorldPos=0.0;
         WorldPos.xz=TerrainPosition[Index].xy+IN.Pos.xz*TerrainSize.z;
         IN.Tex2=IN.Tex3.x*(IN.Tex2/TerrainSize.xy);
         float4x4 Offset=float4x4(-IN.Tex2.x,-IN.Tex2.y,0.0,0.0,-IN.Tex2.x,IN.Tex2.y,0.0,0.0,IN.Tex2.x,-IN.Tex2.y,0.0,0.0,IN.Tex2.x,IN.Tex2.y,0.0,0.0);
         float4 NewUv=float4((WorldPos.xz/TerrainTileSize.xy)+TerrainTileSize.zw,0,0);
         float4 Terrain=tex2Dlod(TerrainSampler,NewUv);     
         float Height=tex2Dlod(TerrainSampler,NewUv+Offset[0]).w+tex2Dlod(TerrainSampler,NewUv+Offset[1]).w+tex2Dlod(TerrainSampler,NewUv+Offset[2]).w+tex2Dlod(TerrainSampler,NewUv+Offset[3]).w;
         WorldPos.y=lerp(Terrain.w,Height*0.25,pow(IN.Tex1.y,5.0))*TerrainHeight;
         OUT.Pos=mul(float4(WorldPos,1.0),ShadowProj);
         OUT.Depth=WorldPos-ShadowPosition.xyz;
         return OUT;
      }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting(Out_Lighting IN)  : COLOR
     {
         IN.Project.xy /=IN.Project.w;
         float Noise=frac(52.9829*frac(dot(IN.Project*ShadowNoise.xy,ShadowNoise.zw)));
         float Index=floor(IN.Project.x*16.0)+floor(IN.Project.y*8.0)*16.0;
         float3 DistortTex=tex3Dlod(LightSampler,float4(IN.Tex2.xy*0.1,0.5/LightingTexture.x,0.0));
         IN.Tex1 +=DistortTex.yxyx*TextureNoise.x-TextureNoise.y;
         float4x4 Terrain=float4x4(tex2Dlod(TerrainSampler,IN.Tex1.xyww),tex2Dlod(TerrainSampler,IN.Tex1.zyww),tex2Dlod(TerrainSampler,IN.Tex1.xwww),tex2Dlod(TerrainSampler,IN.Tex1.zwww));
         float2 BlendFrac=frac(TerrainSize.x*IN.Tex1.xy);
         float2 TerrainNormals=lerp(lerp(Terrain[0].yz,Terrain[2].yz,BlendFrac.y),lerp(Terrain[1].yz,Terrain[3].yz,BlendFrac.y),BlendFrac.x);
         float3 Normals=normalize(float3(TerrainNormals.x,0.75,TerrainNormals.y));
         float4 Diffuse=1.0, NormalMap=0.0;
         float2 Dx=ddx(IN.Tex2.xy*TextureSize), Dy=ddy(IN.Tex2.xy*TextureSize);
         float MipLevel=max(dot(Dx,Dx),dot(Dy,Dy));
         float VerticalMap=saturate(((1.0-Normals.y)-SlopeMin)*SlopeBlend);
         if(VerticalMap<0.99) {
          float4 Layers=float4(Terrain[0].x,Terrain[1].x,Terrain[2].x,Terrain[3].x);
          float4 UvSize=frac(Layers);
          float4 MipLevels=clamp(0.35*log2(MipLevel*UvSize)-0.5,0.0,7.0);
          int4 Levels=floor(MipLevels);
          MipLevels=frac(MipLevels);
          Layers=(0.5+floor(Layers))/TextureLayers;
          float2 Uv=IN.Tex2.xy*UvSize.x;
          #if ParallaxMap == 1
           float3 ViewNor=Heightvec*normalize(IN.ViewNormal);
           Uv +=(tex3Dlod(NormalMapSampler,float4(SamplesOffset[Levels.x].xy+frac(Uv)*SamplesSize[Levels.x].xy,Layers.x,0.0)).x-0.5)*ViewNor;
           Uv +=(tex3Dlod(NormalMapSampler,float4(SamplesOffset[Levels.x].xy+frac(Uv)*SamplesSize[Levels.x].xy,Layers.x,0.0)).x-0.5)*ViewNor;
           Uv +=(tex3Dlod(NormalMapSampler,float4(SamplesOffset[Levels.x].xy+frac(Uv)*SamplesSize[Levels.x].xy,Layers.x,0.0)).x-0.5)*ViewNor;
          #endif
          float4 Tex=SamplesOffset[Levels.x]+frac(Uv.xyxy)*SamplesSize[Levels.x];
          float4 Tex1=float4(Tex.xy,Layers.x,0.0), Tex2=float4(Tex.zw,Layers.x,0.0);
          Diffuse=lerp(tex3Dlod(BaseSampler,Tex1),tex3Dlod(BaseSampler,Tex2),MipLevels.x);
          NormalMap=lerp(tex3Dlod(NormalMapSampler,Tex1),tex3Dlod(NormalMapSampler,Tex2),MipLevels.x);
          if(3.0*Terrain[0].x!=Terrain[1].x+Terrain[2].x+Terrain[3].x) {
           float3x4 DiffuseBlend, NormalMapBlend;
           for(int i=1; i<4; i++ ) {
            Tex=SamplesOffset[Levels[i]]+frac(IN.Tex2.xyxy*UvSize[i])*SamplesSize[Levels[i]];
            Tex1=float4(Tex.xy,Layers[i],0.0), Tex2=float4(Tex.zw,Layers[i],0.0);
            DiffuseBlend[i-1]=lerp(tex3Dlod(BaseSampler,Tex1),tex3Dlod(BaseSampler,Tex2),MipLevels[i]);
            NormalMapBlend[i-1]=lerp(tex3Dlod(NormalMapSampler,Tex1),tex3Dlod(NormalMapSampler,Tex2),MipLevels[i]);
           }
           Diffuse=lerp(lerp(Diffuse,DiffuseBlend[1],BlendFrac.y),lerp(DiffuseBlend[0],DiffuseBlend[2],BlendFrac.y),BlendFrac.x);
           NormalMap=lerp(lerp(NormalMap,NormalMapBlend[1],BlendFrac.y),lerp(NormalMapBlend[0],NormalMapBlend[2],BlendFrac.y),BlendFrac.x);
          }
          NormalMap.yw=NormalMap.yw*2.0-1.0;
         }
         if(VerticalMap>0.01) {
          float MipLevelSlope=clamp(0.35*log2(MipLevel*SlopeSize)-0.5,0.0,7.0);
          int LevelSlope=floor(MipLevelSlope);
          MipLevelSlope=frac(MipLevelSlope);
	  float2 Slope=abs(TerrainNormals*TerrainNormals);
	  Slope /=Slope.x+Slope.y;
          float3 SlopeFlip=-sign(Normals);
          float4 Tex1=SamplesOffset[LevelSlope]+frac(IN.Tex2.xzxz*SlopeSize*SlopeFlip.zyzy)*SamplesSize[LevelSlope];
          float4 Tex2=SamplesOffset[LevelSlope]+frac(IN.Tex2.yzyz*SlopeSize*SlopeFlip.xyxy)*SamplesSize[LevelSlope];
          float4x4 Tex=float4x4(Tex1.xy,SlopeTexture,0.0,Tex1.zw,SlopeTexture,0.0,Tex2.xy,SlopeTexture,0.0,Tex2.zw,SlopeTexture,0.0);
          Diffuse=lerp(Diffuse,lerp(tex3Dlod(BaseSampler,Tex[0])*Slope.y+tex3Dlod(BaseSampler,Tex[2])*Slope.x,tex3Dlod(BaseSampler,Tex[1])*Slope.y+tex3Dlod(BaseSampler,Tex[3])*Slope.x,MipLevelSlope),VerticalMap);
          float4 NormalMapX=lerp(tex3Dlod(NormalMapSampler,Tex[0]),tex3Dlod(NormalMapSampler,Tex[1]),MipLevelSlope);
          float4 NormalMapZ=lerp(tex3Dlod(NormalMapSampler,Tex[2]),tex3Dlod(NormalMapSampler,Tex[3]),MipLevelSlope);
          NormalMapX.yw=(NormalMapX.yw*2.0-1.0)*-SlopeFlip.zy;
          NormalMapZ.yw=(NormalMapZ.yw*2.0-1.0)*-SlopeFlip.xy;
          NormalMap=lerp(NormalMap,NormalMapX*Slope.y+NormalMapZ*Slope.x,VerticalMap);
         }
         float ViewDepth=length(IN.ViewVec.xyz);
         float3 ViewVec=normalize(IN.ViewVec.xyz);
         float3x3 WorldTBN=float3x3(IN.TBNRow1.xyz,IN.TBNRow2.xyz,Normals);
         Normals=normalize(mul(float3(NormalMap.yw,Normalz),WorldTBN));
         float ViewNormal=max(dot(ViewVec,Normals),0.0);
         float3 Specular=0.04+0.96*pow(1.0-Diffuse.w,2.2)*pow(1.0-ViewNormal,5.0);
         float Distribution=pow(Diffuse.w*Diffuse.w+0.004,2.0);
         float4 WorldCamPos=IN.WorldPos-CameraPosition;
         float3 ReflectionVec=reflect(-ViewVec,Normals);
         float3 LightSpecular=IN.Reflect*Reflections(ReflectionVec,Diffuse.w,LightingTexture.z);
         float3 Lighting=DiffuseLight(LightDirection,Normals,LightDirectionColor);
         float4 Disk1=0.0, Disk2=0.0, DiskSin=0.0, DiskCos=0.0;
         #if Shadows == 1
          float3x3 ShadowProjPos=float3x3(IN.WorldPos.xyz-ShadowProjPos1,IN.WorldPos.xyz-ShadowProjPos2,IN.WorldPos.xyz-ShadowProjPos3);
          float2 Split=float2(length(ShadowProjPos[0].xyz),length(ShadowProjPos[1].xyz))/ShadowRanges.xy*4.0;
          Split=saturate(floor(Split+Noise*0.1));
          int Splits=Split.x+Split.y;
          #if ShadowsSoft == 1
           sincos((Noise+float4(2.0,3.0,4.0,5.0))*2.4,DiskSin,DiskCos);
           Disk1=float4(DiskSin.x,DiskCos.x,DiskSin.y,DiskCos.y)*ShadowBlurSplit[Splits]*ShadowBlur.xxyy;
           Disk2=float4(DiskSin.z,DiskCos.z,DiskSin.w,DiskCos.w)*ShadowBlurSplit[Splits]*ShadowBlur.zzww;
          #endif
	  float Depth=dot(IN.WorldPos.xyz-float3(ShadowPositionX[Splits],ShadowPositionY[Splits],ShadowPositionZ[Splits]),ShadowDirection)/ShadowRanges[Splits];
	  float2 ShadowProj=0.5+mul(float4(ShadowProjPos[Splits]+Normals*2.5,1.0),ShadowProjection/ShadowRanges[Splits]*2.0)*float2(0.5,-0.5);
          #if ShadowsSoft == 0
           Lighting *=step(saturate(Depth),tex2Dlod(Shadow1Sampler,ShadowProj.xyyy)[Splits])*IN.Ambient.w;
          #else
           Lighting *=ShadowMapping(Shadow1Sampler,ShadowProj.xyxy+Disk1,ShadowProj.xyxy+Disk2,saturate(Depth),Splits)*IN.Ambient.w;
          #endif
         #endif
         #if Specularity == 1
          LightSpecular +=SpecularLight(LightDirection+ViewVec,Normals,Distribution)*Lighting;
         #endif
         int2 Tiles=TileCount(IN.Project*float2(0.0625,0.03125),ViewDepth/LightingRange.x);
         for(int i=0; i<Tiles.x; i++ ) {
          float TileArray=TileArray(i+128.0,Index,Tiles.y);
          float2x3 Light=PixelLighting(TileArray,WorldCamPos,Normals,ViewVec,Distribution,Disk2,Disk1);
          Lighting +=Light[0], LightSpecular +=Light[1];
         }
         Lighting +=IN.Ambient.xyz;
         Lighting *=(1.0-Specular)*pow(Diffuse.xyz,2.2);
         Lighting +=LightSpecular*Specular;
         return float4(lerp(Lighting,float3(IN.Tex2.w,IN.TBNRow1.w,IN.TBNRow2.w),IN.ViewVec.w),ViewDepth*0.5);
     }
   float4 PS_DepthMapDir(Out_Depth IN) : COLOR
     {
         float Depth=saturate((dot(IN.Depth,ShadowDirection)/ShadowPosition.w)+0.0025);
         return float4(Depth,Depth*Depth,0.0,0.0);
     }

//--------------
// techniques   
//--------------
    technique Lighting
      {
         pass p1
      {		
         vertexShader = compile vs_3_0 VS_Lighting(); 
         pixelShader  = compile ps_3_0 PS_Lighting();
      }
      }
   technique DepthMap
      {
         pass p1
      {
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
      }
      }
