// By EVOLVED
// www.evolved-software.com

#include "Settings.fx"

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 ViewProj:ViewProjection; 
   float4x4 ViewInv:ViewInverse;

//--------------
// tweaks
//--------------
   float4 CameraPosition;
   float4 FogColor;
   float3 FogDensity;
   float4 FogHeight;
   float4 FogHeightColor;
   float3 AmbientSky;
   float3 AmbientGround;
   float3 LightingRange;
   float3 LightingTexture;
   float3 ReflectionColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float4 ShadowNoise;
   float4 ShadowBlur;
   float3 ShadowBlurSplit;
   float4x4 ShadowProj;
   float3 ShadowDirection;
   float4 ShadowPosition;
   float4 ShadowRanges;
   float4x4 ShadowProjection;
   float3 ShadowProjPos1;
   float3 ShadowProjPos2;
   float3 ShadowProjPos3;
   float3 ShadowPositionX;
   float3 ShadowPositionY;
   float3 ShadowPositionZ;
   float4x4 VarianceShadowProjection;
   float3 VarianceShadowPosition;
   float4 VariancePosition;
   float4 TreeWindTimer;
   float4 TreeWindSize={1000,2000,400,5};
   float3 TreeWindPower={32.0,8.0,4.0};

//--------------
// textures
//--------------
   texture BaseTexture <string Name = "";>;
   sampler BaseSampler=sampler_state
      {
         Texture=<BaseTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture NormalMapTexture <string Name = "";>;
   sampler NormalMapSampler=sampler_state
      {
 	 Texture=<NormalMapTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture NullTexture <string Name = "";>;
   texture LightTexture <string Name="";>;
   sampler LightSampler=sampler_state
      {
	 Texture=<LightTexture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      };
   texture LightDataTexture <string Name = "";>;
   sampler LightDataSampler=sampler_state
      {
 	 Texture=<LightDataTexture>;
  	 MagFilter=None;
	 MinFilter=None;
	 MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow1Texture <string Name = "";>;
   sampler Shadow1Sampler=sampler_state
      {
 	 Texture=<Shadow1Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
         AddressU=Border;
         AddressV=Border;
         AddressW=Border;
         BorderColor=16646655;
      };
   texture Shadow2Texture <string Name = "";>;
   sampler Shadow2Sampler=sampler_state
      {
 	 Texture=<Shadow2Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };
   texture Shadow3Texture <string Name = "";>;
   sampler Shadow3Sampler=sampler_state
      {
 	 Texture=<Shadow3Texture>;
         MagFilter=Linear;
         MinFilter=Linear;
         MipFilter=None;
      	 ADDRESSU=CLAMP;
         ADDRESSV=CLAMP;
      };

//--------------
// Functions
//--------------
   #include "Tile Count.fx"
   #include "Tile Array.fx"
   #include "Diffuse Light.fx"
   #include "Spot Light.fx"
   #if Specularity == 1
    #include "Specular Light.fx"
   #endif
   #include "Vertex Fog.fx"
   #include "Vertex Ambient.fx"
   #include "Vertex Lighting.fx"
   #include "Reflections.fx"
   #if TerrainShadows == 1
    #include "Variance Shadow Mapping.fx"
   #endif

//--------------
// structs 
//--------------
   struct Input
      {
         float4 Pos:POSITION;
         float3 Normal:NORMAL;
         float2 Tex0:TEXCOORD0;
         float2 Tex1:TEXCOORD1;
      };
   struct Out_Lighting
      {
         float4 Pos:POSITION;
         float4 Tex:TEXCOORD0;
         float4 TBNRow1:TEXCOORD1;
         float4 TBNRow2:TEXCOORD2;
         float4 TBNRow3:TEXCOORD3;
         float4 ViewVec:TEXCOORD4;
         float4 WorldPos:TEXCOORD5;
         float4 Lighting:TEXCOORD6;
         float4 Ambient:COLOR0;
         float4 Reflect:COLOR1;
      };
   struct Out_Depth
      {
         float4 Pos:POSITION; 
         float4 Tex:TEXCOORD0; 
         float3 Depth:TEXCOORD1;
      };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN) 
      {
         Out_Lighting OUT;
         float3 WorldPos=mul(IN.Pos,World);
         float3 Normals=normalize(frac(IN.Normal)*2.0-1.0);
         float3 Tangent=normalize((IN.Normal/10000.0)*2.0-1.0);
         OUT.Pos=mul(float4(WorldPos,1),ViewProj);
         OUT.Tex=float4(IN.Tex0,IN.Tex1);
         OUT.ViewVec.xyz=ViewInv[3].xyz-WorldPos;
         float3 ViewVec=normalize(OUT.ViewVec.xyz);
         float ViewNormal=sign(dot(ViewVec,Normals));
         Normals *=ViewNormal; Tangent *=ViewNormal;
         OUT.Tex.xy=lerp(float2(1.0-OUT.Tex.x,OUT.Tex.y+0.5),OUT.Tex.xy,max(ViewNormal,0.0));
         OUT.TBNRow1.xyz=Tangent;
         OUT.TBNRow2.xyz=cross(Normals,Tangent);
         OUT.TBNRow3.xyz=Normals;
         OUT.WorldPos=float4(WorldPos,0);
         float ViewDepth=length(OUT.ViewVec.xyz);
         float4 Project=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z,OUT.Pos.w);
         Project.xy /=Project.w;
         OUT.Lighting.w=1.0;
         #if Shadows == 1
          #if TerrainShadows == 1
           float2 ShadowProj=float2(0.75,0.5)+mul(float4(WorldPos,1.0),VarianceShadowProjection)*float2(0.25,-0.5);
           float Depth=dot(WorldPos-VarianceShadowPosition,ShadowDirection)/ShadowRanges.w;
           float Edge=saturate(VariancePosition.w-length(WorldPos-VariancePosition.xyz));
           OUT.Lighting.w=lerp(1.0,VarianceShadowMapping(ShadowProj,saturate(Depth)),Edge);
          #endif
         #endif
         float4 WorldCamPos=OUT.WorldPos-CameraPosition;
         OUT.Lighting.xyz=0.0;
         float Index=floor(Project.x*16.0)+floor(Project.y*8.0)*16.0;
         int2 Tiles=TileCount(Project*float2(0.0625,0.03125),ViewDepth/LightingRange.x);
          for(int i=0; i<Tiles.x; i++ ) {
          float4 TileArray=float4(TileArray(i+128.0,Index,Tiles.y)+0.001953125,0.97265625,0.0,0.0);
          OUT.Lighting.xyz +=VertexLighting(TileArray,WorldCamPos,Normals);
         }
	 float3 AmbientDir=normalize(float3(-LightDirection.x,1.0,-LightDirection.z));
         OUT.Ambient.xyz=lerp(AmbientGround,AmbientSky,0.5+dot(Normals,AmbientDir)*0.5);
         float LightSegment=clamp(floor((ViewDepth/LightingRange.z)*16.0),0.0,15.0)*0.00390625;
         int LightCount=tex2Dlod(LightDataSampler,float4(0.12890625,LightSegment,0.0,0.0));
         float4 AmbientLighting=0.0;
         for (int l=0; l < LightCount; l++) {
          AmbientLighting=max(VertexAmbient((34.0+l)*0.00390625,LightSegment,WorldCamPos),AmbientLighting);
         }
         OUT.Ambient.xyz=lerp(OUT.Ambient.xyz,AmbientLighting.xyz,AmbientLighting.w);
         OUT.Ambient.w=1.0;
         OUT.Reflect.xyz=lerp(ReflectionColor,1.0,AmbientLighting.w);
         OUT.Reflect.w=max((0.5+dot(-LightDirection,Normals)*0.5)*dot(normalize(-LightDirection+ViewVec),ViewVec),0.0);
         float4 Fog=VertexFog(ViewDepth,WorldPos,ViewVec,LightDirection,LightDirectionColor,FogColor,FogDensity,FogHeightColor,FogHeight);
         OUT.TBNRow1.w=Fog.x, OUT.TBNRow2.w=Fog.y, OUT.TBNRow3.w=Fog.z, OUT.ViewVec.w=Fog.w;
         return OUT;
      }
   Out_Depth VS_DepthMapDir(Input IN)
      {
         Out_Depth OUT;
         float3 WorldPos=mul(IN.Pos,World);
         OUT.Pos=mul(float4(WorldPos,1.0),ShadowProj);
         OUT.Tex=float4(IN.Tex0,IN.Tex1);
         OUT.Depth=WorldPos-ShadowPosition.xyz;
         return OUT;
      }

//--------------
// pixel shader
//--------------
    float4 PS_Lighting(Out_Lighting IN)  : COLOR
      {
         float ViewDepth=length(IN.ViewVec.xyz);
         float3 ViewVec=normalize(IN.ViewVec.xyz);
         float4 Diffuse=tex3Dlod(BaseSampler,IN.Tex);
         float4 NormalMap=tex3Dlod(NormalMapSampler,IN.Tex);
         Diffuse.xyz=pow(Diffuse.xyz,2.2);
         float3x3 WorldTBN=float3x3(IN.TBNRow1.xyz,IN.TBNRow2.xyz,IN.TBNRow3.xyz);
         float3 Normals=normalize(mul(float3(NormalMap.yw*2.0-1.0,0.25),WorldTBN));
         float ViewNormal=max(dot(ViewVec,Normals),0.0);
         float3 Specular=0.04+0.96*pow(1.0-NormalMap.z,2.2)*pow(1.0-ViewNormal,5.0);
         float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2.0);
         float3 ReflectionVec=reflect(-ViewVec,Normals);
         float3 LightSpecular=IN.Reflect*Reflections(-ReflectionVec,NormalMap.z,LightingTexture.z);
         float3 Lighting=max(dot(LightDirection,Normals),0.0)*LightDirectionColor;
         #if Shadows == 1
          float3 ShadowProjPos[3]={IN.WorldPos.xyz-ShadowProjPos1,IN.WorldPos.xyz-ShadowProjPos2,IN.WorldPos.xyz-ShadowProjPos3};
          float2 Split=float2(length(ShadowProjPos[0].xyz),length(ShadowProjPos[1].xyz))/ShadowRanges.xy*4.0;
          Split=saturate(floor(Split));
          Split.x +=Split.y;
	  float Depth=dot(IN.WorldPos.xyz-float3(ShadowPositionX[Split.x],ShadowPositionY[Split.x],ShadowPositionZ[Split.x]),ShadowDirection)/ShadowRanges[Split.x];
	  float2 ShadowProj=0.5+mul(float4(ShadowProjPos[Split.x],1.0),ShadowProjection/ShadowRanges[Split.x]*2.0)*float2(0.5,-0.5);
          float Shadow=step(saturate(Depth),tex2Dlod(Shadow1Sampler,ShadowProj.xyyy)[Split.x])*IN.Lighting.w;
          Lighting *=Shadow;
          IN.Reflect.w *=Shadow;
         #endif
         #if Specularity == 1
          LightSpecular +=SpecularLight(LightDirection+ViewVec,Normals,Distribution)*Lighting;
         #endif
         Lighting +=IN.Lighting.xyz+IN.Ambient.xyz;
         Lighting *=(1.0-Specular)*Diffuse.xyz;
         Lighting +=LightSpecular*Specular;
	 Lighting +=pow(Diffuse.xyz,0.5)*IN.Reflect.w*NormalMap.x*LightDirectionColor;
         return float4(lerp(Lighting*IN.Ambient.w,float3(IN.TBNRow1.w,IN.TBNRow2.w,IN.TBNRow3.w),IN.ViewVec.w),ceil(Diffuse.w-0.5)*ViewDepth*0.5);
      }
    float4 PS_DepthMapDir(Out_Depth IN) : COLOR
      {
         return float4(0.004+(dot(IN.Depth,ShadowDirection)/ShadowPosition.w).xxx,tex3Dlod(BaseSampler,IN.Tex).w);
      }

//--------------
// techniques   
//--------------
    technique Lighting
      {

         pass p1
      {      
         vertexShader = compile vs_3_0 VS_Lighting();
         pixelShader  = compile ps_3_0 PS_Lighting();
         AlphaBlendEnable=false;
         AlphaRef=0;
      }
      }
    technique DepthMap1
      {
         pass p1
      {		
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
         AlphaBlendEnable=false;
         AlphaRef=128;
         ColorWriteEnable=1;
      }
      }
    technique DepthMap2
      {
         pass p1
      {		
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
         AlphaBlendEnable=false;
         AlphaRef=128;
         ColorWriteEnable=2;
      }
      }
    technique DepthMap3
      {
         pass p1
      {		
         VertexShader = compile vs_3_0 VS_DepthMapDir();
         PixelShader  = compile ps_3_0 PS_DepthMapDir();
         AlphaBlendEnable=false;
         AlphaRef=128;
         ColorWriteEnable=4;
      }
      }

