// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 ViewProj:ViewProjection;

//--------------
// tweaks
//--------------
   float4 Position[9];
   float4 Size[9];

//--------------
// Textures
//--------------
   texture Depth1Texture <string Name = " ";>;
   sampler Depth1Sampler=sampler_state 
      {
         Texture=<Depth1Texture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture Depth2Texture <string Name = " ";>;
   sampler Depth2Sampler=sampler_state 
      {
         Texture=<Depth2Texture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture Depth3Texture <string Name = " ";>;
   sampler Depth3Sampler=sampler_state 
      {
         Texture=<Depth3Texture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture Depth4Texture <string Name = " ";>;
   sampler Depth4Sampler=sampler_state 
      {
         Texture=<Depth4Texture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture Depth5Texture <string Name = " ";>;
   sampler Depth5Sampler=sampler_state 
      {
         Texture=<Depth5Texture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };
   texture Depth6Texture <string Name = " ";>;
   sampler Depth6Sampler=sampler_state 
      {
         Texture=<Depth6Texture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };

//--------------
// structs 
//--------------
   struct OutPut
      {
         float4 Pos:POSITION;
         float4 Proj1:TEXCOORD0;
         float4 Proj2:TEXCOORD1;
         float4 Proj3:TEXCOORD2;
         float4 Proj4:TEXCOORD3;
         float Depth:TEXCOORD4;
         float2 HizLevel:TEXCOORD5;
      };

//--------------
// vertex shader
//--------------
   OutPut VS(float4 Pos:POSITION)
      {
         OutPut OUT;
         int Index=floor(Pos.x);
         float4 BoundsPos=Position[Index];
         float4 BoundsSize=Size[Index];
         OUT.Pos=float4(0.0,0.0,1.0,1.0);
         float4 Proj=mul(BoundsPos+BoundsSize,ViewProj);
         Proj.xy=float2(Proj.x*0.5+0.5*Proj.w,0.5*Proj.w-Proj.y*0.5)/Proj.w;
         float3 VerMin=Proj.xyz; float2 VerMax=Proj.xy;
         Proj=mul(BoundsPos-BoundsSize,ViewProj);
         Proj.xy=float2(Proj.x*0.5+0.5*Proj.w,0.5*Proj.w-Proj.y*0.5)/Proj.w;
         VerMin=min(VerMin,Proj.xyz); VerMax=max(VerMax,Proj.xy);
         Proj=mul(BoundsPos+float4(-BoundsSize.x,BoundsSize.y,BoundsSize.z,0.0),ViewProj);
         Proj.xy=float2(Proj.x*0.5+0.5*Proj.w,0.5*Proj.w-Proj.y*0.5)/Proj.w;
         VerMin=min(VerMin,Proj.xyz); VerMax=max(VerMax,Proj.xy);
         Proj=mul(BoundsPos+float4(BoundsSize.x,BoundsSize.y,-BoundsSize.z,0.0),ViewProj);
         Proj.xy=float2(Proj.x*0.5+0.5*Proj.w,0.5*Proj.w-Proj.y*0.5)/Proj.w;
         VerMin=min(VerMin,Proj.xyz); VerMax=max(VerMax,Proj.xy);
         Proj=mul(BoundsPos+float4(-BoundsSize.x,BoundsSize.y,-BoundsSize.z,0.0),ViewProj);
         Proj.xy=float2(Proj.x*0.5+0.5*Proj.w,0.5*Proj.w-Proj.y*0.5)/Proj.w;
         VerMin=min(VerMin,Proj.xyz); VerMax=max(VerMax,Proj.xy);
         Proj=mul(BoundsPos+float4(BoundsSize.x,-BoundsSize.y,BoundsSize.z,0.0),ViewProj);
         Proj.xy=float2(Proj.x*0.5+0.5*Proj.w,0.5*Proj.w-Proj.y*0.5)/Proj.w;
         VerMin=min(VerMin,Proj.xyz); VerMax=max(VerMax,Proj.xy);
         Proj=mul(BoundsPos+float4(-BoundsSize.x,-BoundsSize.y,BoundsSize.z,0.0),ViewProj);
         Proj.xy=float2(Proj.x*0.5+0.5*Proj.w,0.5*Proj.w-Proj.y*0.5)/Proj.w;
         VerMin=min(VerMin,Proj.xyz); VerMax=max(VerMax,Proj.xy);
         Proj=mul(BoundsPos+float4(BoundsSize.x,-BoundsSize.y,-BoundsSize.z,0.0),ViewProj);
         Proj.xy=float2(Proj.x*0.5+0.5*Proj.w,0.5*Proj.w-Proj.y*0.5)/Proj.w;
         VerMin=min(VerMin,Proj.xyz); VerMax=max(VerMax,Proj.xy);
         OUT.Proj1=float4(VerMin.xy,0.0,0.0);
         OUT.Proj2=float4(VerMax.xy,0.0,0.0);
         OUT.Proj3=float4(VerMin.x,VerMax.y,0.0,0.0);
         OUT.Proj4=float4(VerMax.x,VerMin.y,0.0,0.0);
         OUT.Depth=VerMin.z*0.5;
         VerMin.x=max(VerMax.x-VerMin.x,VerMax.y-VerMin.y)*32;
         OUT.HizLevel.xy=0;
         if(VerMin.x>2) OUT.HizLevel=float2(0,1);
         if(VerMin.x>4) OUT.HizLevel=float2(0,2);
         if(VerMin.x>8) OUT.HizLevel=float2(1,0);
         if(VerMin.x>16) OUT.HizLevel=float2(1,1);
         if(VerMin.x>32) OUT.HizLevel=float2(1,2);
         return OUT;
      }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
      {
         float4 Depth[3];
         if(IN.HizLevel.x<1) {
          Depth[0]=float4(tex2Dlod(Depth1Sampler,IN.Proj1).w,tex2Dlod(Depth1Sampler,IN.Proj2).w,tex2Dlod(Depth1Sampler,IN.Proj3).w,tex2Dlod(Depth1Sampler,IN.Proj4).w);
          Depth[1]=float4(tex2Dlod(Depth2Sampler,IN.Proj1).w,tex2Dlod(Depth2Sampler,IN.Proj2).w,tex2Dlod(Depth2Sampler,IN.Proj3).w,tex2Dlod(Depth2Sampler,IN.Proj4).w);
          Depth[2]=float4(tex2Dlod(Depth3Sampler,IN.Proj1).w,tex2Dlod(Depth3Sampler,IN.Proj2).w,tex2Dlod(Depth3Sampler,IN.Proj3).w,tex2Dlod(Depth3Sampler,IN.Proj4).w);
         }
         else {
          Depth[0]=float4(tex2Dlod(Depth4Sampler,IN.Proj1).w,tex2Dlod(Depth4Sampler,IN.Proj2).w,tex2Dlod(Depth4Sampler,IN.Proj3).w,tex2Dlod(Depth4Sampler,IN.Proj4).w);
          Depth[1]=float4(tex2Dlod(Depth5Sampler,IN.Proj1).w,tex2Dlod(Depth5Sampler,IN.Proj2).w,tex2Dlod(Depth5Sampler,IN.Proj3).w,tex2Dlod(Depth5Sampler,IN.Proj4).w);
          Depth[2]=float4(tex2Dlod(Depth6Sampler,IN.Proj1).w,tex2Dlod(Depth6Sampler,IN.Proj2).w,tex2Dlod(Depth6Sampler,IN.Proj3).w,tex2Dlod(Depth6Sampler,IN.Proj4).w);
         }
         if(dot(step(IN.Depth,Depth[IN.HizLevel.y]),1.0)<0.5) discard;
         return 0;
      }

//--------------
// techniques   
//--------------
  technique Pixel
      {
         pass p1
      {
         vertexShader = compile vs_3_0 VS();
         pixelShader  = compile ps_3_0 PS();
         ColorWriteEnable=8;
         zwriteenable=false;
         zenable=false;
         CullMode=none;
         FillMode=point;
      }
      }