// By EVOLVED
// www.evolved-software.com

//-------------
// tweaks
//--------------
   float4 ViewSize;
   float MipLevel=0.0;
   float Blur=0.0;

//--------------
// Textures
//--------------
   texture RenderTexture <string Name = " ";>;
   sampler RenderSampler=sampler_state 
      {
         Texture=<RenderTexture>;
      };
   texture TerrainTexture <string Name = " ";>;
   sampler TerrainSampler=sampler_state 
      {
         Texture=<TerrainTexture>;
         MagFilter=None;
         MinFilter=None;
         MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct InPut
      {
          float4 Pos:POSITION;
      };
   struct OutPut
      {
         float4 Pos:POSITION; 
         float4 Tex:TEXCOORD0;
      };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN)
      {
         OutPut OUT; 
         OUT.Pos=IN.Pos;
         OUT.Tex.xy=((float2(IN.Pos.x/ViewSize.z,-IN.Pos.y/ViewSize.w)+1.0)*0.5)+ViewSize.xy;
         OUT.Tex.zw=0.0;
         return OUT;
      }
   OutPut VS_ReflectionBlur(InPut IN)
      {
         OutPut OUT; 
         OUT.Pos=IN.Pos;
         OUT.Tex.xy=((float2(IN.Pos.x/ViewSize.z,IN.Pos.y/ViewSize.w)+1.0)*0.5)+ViewSize.xy;
         OUT.Tex.zw=0.0;
         return OUT;
      }
   OutPut VS_TerrainSave(InPut IN)
      {
         OutPut OUT; 
         OUT.Pos=IN.Pos;
         OUT.Tex.xy=(float2(ViewSize.x,ViewSize.y)*0.25)+((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)*0.25;
         OUT.Tex.zw=0.0;
         return OUT;
      }

//--------------
// pixel shader
//--------------
    float4 PS(OutPut IN)  : COLOR
      {
         return tex2Dlod(RenderSampler,IN.Tex);
      }
    float4 PS_Cookie(OutPut IN)  : COLOR
      {
         return pow(tex2Dlod(RenderSampler,float4(IN.Tex.x,1.0-IN.Tex.y,0.0,0.0)),2.2);
      }
    float4 PS_ReflectionBlur(OutPut IN)  : COLOR
      {
         float4 ReflectionBlur=0;
         for(int x = -3; x < 4; x++) {
          for(int y = -3; y < 4; y++) {
           float Weight=max(3.0-length(float2(x,y)),0.0);
           ReflectionBlur +=tex2Dlod(RenderSampler,IN.Tex+float4(x,y,0.0,0.0)*float4(0.5/512.0,0.5/256.0,0.0,0.0)*Blur)*Weight;
          }
         }
         float4 FrameRender=ReflectionBlur/ReflectionBlur.w;
         float MaxComponent=max(max(FrameRender.x,FrameRender.y),FrameRender.z);
         float fExp=ceil(log(MaxComponent)/log(1.04));
         fExp=saturate((fExp+128.0)/255.0);
         return float4(FrameRender.xyz/pow(1.04,fExp*255.0-128.0),fExp);
      }
    float4 PS_Terrain(OutPut IN) : COLOR
      {
         return tex2Dlod(RenderSampler,float4(IN.Tex.xy,0.0,MipLevel));
      }
    float4 PS_TerrainSave1(OutPut IN) : COLOR
      {
         float4 Terrain=tex2Dlod(TerrainSampler,float4(IN.Tex.xy,0.0,0.0));
         return float4(0.5+Terrain.yz*0.5,floor(Terrain.w+127)/255.0,frac(Terrain.w+127));
      }
    float4 PS_TerrainSave2(OutPut IN) : COLOR
      {
         float4 Terrain=tex2Dlod(TerrainSampler,float4(IN.Tex.xy,0.0,0.0));
         return float4(floor(Terrain.x-1.0)/255.0,frac(Terrain.x-1.0),0,0);
      }

//--------------
// techniques   
//--------------
    technique Texture
      {
         pass p1
      {	
         VertexShader = compile vs_3_0 VS();
         PixelShader  = compile ps_3_0 PS(); 
      }
      }
    technique Cookie
      {
         pass p1
      {	
         VertexShader = compile vs_3_0 VS();
         PixelShader  = compile ps_3_0 PS_Cookie(); 
      }
      }
    technique ReflectionBlur
      {
         pass p1
      {	
         VertexShader = compile vs_3_0 VS_ReflectionBlur();
         PixelShader  = compile ps_3_0 PS_ReflectionBlur(); 
      }
      }
    technique Terrain
      {
         pass p1
      {	
         VertexShader = compile vs_3_0 VS();
         PixelShader  = compile ps_3_0 PS_Terrain(); 
      }
      }
    technique TerrainSave1
      {
         pass p1
      {	
         VertexShader = compile vs_3_0 VS_TerrainSave();
         PixelShader  = compile ps_3_0 PS_TerrainSave1(); 
      }
      }
    technique TerrainSave2
      {
         pass p1
      {	
         VertexShader = compile vs_3_0 VS_TerrainSave();
         PixelShader  = compile ps_3_0 PS_TerrainSave2(); 
      }
      }