// By EVOLVED
// www.evolved-software.com


//--------------
// un-tweaks
//--------------
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 World:World;
   float4x4 ViewInv:ViewInverse;
   float4x4 ViewProj:ViewProjection;
   float4x4 PrevViewProj;
   float Timer;

//--------------
// tweaks
//--------------
   float2 ViewSize;
   float4 FogColor;
   float2 Speed1={-2,8};
   float2 Speed2={1,-16};
   float EdgeSoftness=0.08;
   float Heightvec=0.1;

//--------------
// Textures
//--------------
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	Texture=<NormalMapTexture>;
	MinFilter=point;
	MipFilter=none;
      };
   texture FogTexture <string Name="";>;
   sampler FogSampler=sampler_state
      {
	Texture=<FogTexture>;
      };
   texture ReflectionTexture <string Name="";>;
   sampler ReflectionSampler=sampler_state
      {
	Texture=<ReflectionTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
	AddressW=Clamp;
      };
   texture DepthTexture <string Name = "";>;	
   sampler DepthSampler=sampler_state 
      {
 	Texture=<DepthTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
      };

//--------------
// structs 
//--------------
   struct Input
     {
 	float4 Pos:POSITION;
    	float2 Tex:TEXCOORD; 
      };
   struct Out_Lighting
      {
	float4 Pos:POSITION;
 	float4 Tex:TEXCOORD0;
  	float3 WorldPos:TEXCOORD2;
  	float4 Proj1:COLOR0;
  	float4 Proj2:COLOR1;
      };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN)  
     {
 	Out_Lighting OUT;
  	OUT.Pos=mul(IN.Pos,WorldVP);
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Tex.xy=float2(-WorldPos.z*0.001,-WorldPos.x*0.0014)*IN.Tex.x+(Timer*Speed1);
	OUT.Tex.zw=float2(-WorldPos.z*0.001,-WorldPos.x*0.0012)*IN.Tex.y+(Timer*Speed2);
	OUT.WorldPos=WorldPos;
	OUT.Proj1=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z*0.5,OUT.Pos.w);
	OUT.Proj2=mul(float4(WorldPos,1),PrevViewProj);
	OUT.Proj2=float4(OUT.Proj2.x*0.5+0.5*OUT.Proj2.w,0.5*OUT.Proj2.w-OUT.Proj2.y*0.5,OUT.Proj2.z*0.5,OUT.Proj2.w);
	return OUT;
     }
   Out_Lighting VS_Distortion(Input IN)
     {
 	Out_Lighting OUT;
  	OUT.Pos=mul(IN.Pos,WorldVP);
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Tex.xy=float2(-WorldPos.z*0.001,-WorldPos.x*0.0014)*IN.Tex.x+(Timer*Speed1);
	OUT.Tex.zw=float2(-WorldPos.z*0.001,-WorldPos.x*0.0012)*IN.Tex.y+(Timer*Speed2);
	OUT.WorldPos=WorldPos;
	OUT.Proj1=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z*0.5,OUT.Pos.w);
	OUT.Proj2=0.0;
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting(Out_Lighting IN)  : COLOR
     {
	float Depth=tex2D(DepthSampler,(IN.Proj2.xy/IN.Proj2.w)+ViewSize).w;
	float UnderWater=sign(ViewInv[3].y-IN.WorldPos.y);
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos);
	IN.Tex +=(Heightvec*((tex2D(NormalMapSampler,IN.Tex.xy).w+tex2D(NormalMapSampler,IN.Tex.zw).w*0.2)-0.61))*-ViewVec.zxzx;
	IN.Tex +=(Heightvec*((tex2D(NormalMapSampler,IN.Tex.xy).w+tex2D(NormalMapSampler,IN.Tex.zw).w*0.2)-0.61))*-ViewVec.zxzx;
	IN.Tex +=(Heightvec*((tex2D(NormalMapSampler,IN.Tex.xy).w+tex2D(NormalMapSampler,IN.Tex.zw).w*0.2)-0.61))*-ViewVec.zxzx;
	float3 NormalMap1=tex2D(NormalMapSampler,IN.Tex.xy)*2.0-1.0;
	float3 NormalMap2=tex2D(NormalMapSampler,IN.Tex.zw)*2.0-1.0;
	float3 Normals=normalize(float3(-(NormalMap1.y+NormalMap2.y*0.5),UnderWater*2.5,-(NormalMap1.x+NormalMap2.x*0.5)));
	float ViewNormal=max(dot(ViewVec,Normals),0.0);
	float Fresnel=0.04+0.96*pow(1.0-ViewNormal,5.0);
	float4 WaterFog=tex1D(FogSampler,0.0);
	WaterFog.xyz=pow(WaterFog.xyz,2.2);
        WaterFog.w *=1020.0;
	float4 Reflections=tex2D(ReflectionSampler,(IN.Proj1.xy/IN.Proj1.w)+ViewSize+(Normals.xz*0.05));
        Reflections.xyz *=pow(1.04,Reflections.w*255.0-128.0);
	float WaterFogDist=((ViewInv[3].y-IN.WorldPos.y)*0.5)+WaterFog.w;
	WaterFogDist=saturate(1-exp(-(Depth/WaterFogDist)));
        float4 Water=float4(lerp(WaterFog.xyz,Reflections.xyz,Fresnel),max(WaterFogDist,Fresnel));
	Water.w *=saturate((Depth-IN.Proj2.z)*EdgeSoftness);
        float2 FogDist=saturate(1.0-exp(-(IN.Proj1.z/float2(FogColor.w,WaterFog.w))));
	return lerp(lerp(Water,float4(FogColor.xyz,1.0),FogDist.x),float4(WaterFog.xyz,max(FogDist.y,Fresnel)),max(-UnderWater,0.0));
     }
    float4 PS_Distortion(Out_Lighting IN)  : COLOR
     {
	float Depth=tex2D(DepthSampler,(IN.Proj1.xy/IN.Proj1.w)+ViewSize).w;
	float UnderWater=sign(ViewInv[3].y-IN.WorldPos.y);
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos);
	IN.Tex +=(Heightvec*((tex2D(NormalMapSampler,IN.Tex.xy).w+tex2D(NormalMapSampler,IN.Tex.zw).w*0.2)-0.61))*-ViewVec.zxzx;
	IN.Tex +=(Heightvec*((tex2D(NormalMapSampler,IN.Tex.xy).w+tex2D(NormalMapSampler,IN.Tex.zw).w*0.2)-0.61))*-ViewVec.zxzx;
	IN.Tex +=(Heightvec*((tex2D(NormalMapSampler,IN.Tex.xy).w+tex2D(NormalMapSampler,IN.Tex.zw).w*0.2)-0.61))*-ViewVec.zxzx;
	float3 NormalMap1=tex2D(NormalMapSampler,IN.Tex.xy)*2.0-1.0;
	float3 NormalMap2=tex2D(NormalMapSampler,IN.Tex.zw)*2.0-1.0;
	float3 Normals=normalize(float3(-(NormalMap1.y+NormalMap2.y*0.5),UnderWater*2.5,-(NormalMap1.x+NormalMap2.x*0.5)));
	float ViewNormal=max(dot(ViewVec,Normals),0.0);
	float Fresnel=0.04+0.96*pow(1.0-ViewNormal,5.0);
	return float4(0.5+float2(-Normals.x,Normals.z)*saturate(20.0/(1.0+IN.Proj1.z)),1.0,saturate((Depth-IN.Proj1.z)*EdgeSoftness)*(1.0-Fresnel));
     }

//--------------
// techniques
//--------------
    technique Lighting
      {
 	pass p1
      {		
 	vertexShader=compile vs_3_0 VS_Lighting(); 
 	pixelShader=compile ps_3_0 PS_Lighting();
        ColorWriteEnable=7;
	AlphaBlendEnable=true;
	zwriteenable=false;
      }
      }
    technique Distortion
      {
 	pass p1
      {
 	vertexShader = compile vs_3_0 VS_Distortion();
 	pixelShader  = compile ps_3_0 PS_Distortion();
        ColorWriteEnable=7;
	AlphaBlendEnable=true;
	zwriteenable=false;
      }
      }
