// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 ViewProj:ViewProjection;
   float4x4 View:View;
   float4x4 ViewInv:ViewInverse;
   float4x4 PrevViewProj;

//--------------
// tweaks
//--------------
   float2 ViewSize;
   float2 Aspect;
   float4 FogColor;
   float3 AmbientColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float4x4 LightDirectionShadow;
   float LightRange;
   int DynamicPointCount=0;
   float4 PointPositionX;
   float4 PointPositionY;
   float4 PointPositionZ;
   float4 PointRange;
   float4 PointRed;
   float4 PointGreen;
   float4 PointBlue;
   int DynamicSpotCount=0;
   float4 SpotPositionX;
   float4 SpotPositionY;
   float4 SpotPositionZ;
   float4 SpotRange;
   float4 SpotRed;
   float4 SpotGreen;
   float4 SpotBlue;
   float4 SpotDirX;
   float4 SpotDirY;
   float4 SpotDirZ;
   float4 SpotMin;
   float4 SpotMax;

//--------------
// Textures
//--------------
   texture ParticleTexture <string Name = "";>;	
   sampler ParticleSampler=sampler_state 
      {
 	Texture=<ParticleTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=8;
      };
   texture ColorTexture <string Name = "";>;	
   sampler ColorSampler=sampler_state 
      {
 	Texture=<ColorTexture>;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };
   texture PixelTexture <string Name = "";>;	
   sampler PixelSampler=sampler_state 
      {
 	Texture=<PixelTexture>;
	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };
   texture LightsTexture <string Name = "";>;	
   sampler LightsSampler=sampler_state 
      {
 	Texture=<LightsTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };
   texture ShadowTexture <string Name = "";>;	
   sampler ShadowSampler=sampler_state 
      {
 	Texture=<ShadowTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture DepthTexture <string Name = "";>;	
   sampler DepthSampler=sampler_state 
      {
 	Texture=<DepthTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float3 Pos:POSITION;	
	float2 Tex0:TEXCOORD0;
 	float2 Tex1:TEXCOORD1;
 	float2 Tex2:TEXCOORD2;
 	float2 Tex3:TEXCOORD3;
 	float2 Tex4:TEXCOORD4;
 	float2 Tex5:TEXCOORD5;
 	float2 Tex6:TEXCOORD6;
 	float3 Color:COLOR0;
     };
   struct OutPut
     {
	float4 Pos:POSITION;
	float4 Tex:TEXCOORD0;
	float4 Proj:TEXCOORD1;
	float Frame:TEXCOORD2;
	float4 Color:TEXCOORD3;
	float4 Lighting:TEXCOORD4;
	float Softness:TEXCOORD5;
     };

//--------------
// vertex shader
//--------------
   OutPut VS_Lighting(InPut IN) 
     {
 	OutPut OUT;
	float2 Pixel=floor(float2(IN.Pos.z,IN.Pos.z/254.0));
	Pixel=float2((Pixel.x-Pixel.y*254.0)-256.0,Pixel.y+256.0)*0.00390625;
	float4 Particle=tex2Dlod(PixelSampler,float4(Pixel.x*0.5,Pixel.y,0.0,0.0));
	float4 ParticlePrevious=tex2Dlod(PixelSampler,float4(0.5+Pixel.x*0.5,Pixel.y,0.0,0.0));
	float3 WorldPos=Particle.xyz*IN.Tex5.x;
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Curve=tex2Dlod(ColorSampler,float4(0.5+Particle.w*0.5,(IN.Tex6.x+0.5)/1024.0,0,0));
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
	OUT.Proj=mul(float4(WorldPos,1.0),PrevViewProj);
	float2 PreviousPos=mul(float4(ParticlePrevious.xyz*IN.Tex5.x,1.0),ViewProj);
	PreviousPos=(OUT.Pos.xy-PreviousPos)/Aspect;
	float Dirlength=1.0+length(PreviousPos*IN.Tex1.y)/(saturate(Particle.w-ParticlePrevious.w)*IN.Tex5.x);
	float2 Size=(IN.Pos.xy*IN.Tex1.x)*Curve.y;
	float Strobe=saturate(sin(Particle.w*IN.Tex4.x).xx+0.5);
	Size +=Strobe*(IN.Pos.xy*IN.Tex3.y)*Curve.z;
	Size *=1.0+OUT.Pos.z*IN.Tex2.x;
	float Angle=lerp(IN.Tex2.y+(Particle.w*IN.Tex3.x),atan2(PreviousPos.x/OUT.Pos.w,PreviousPos.y/OUT.Pos.w),sign(IN.Tex1.y));
	Size=mul(float2(Size.x,Size.y*Dirlength*Dirlength),float2x2(cos(Angle),-sin(Angle),sin(Angle),cos(Angle)));
	OUT.Pos.xy +=Size*IN.Tex5.x*Aspect*ceil(saturate(Particle.w));
	OUT.Proj.xy +=Size*IN.Tex5.x*Aspect*ceil(saturate(Particle.w));
	OUT.Proj=float4(OUT.Proj.x*0.5+0.5*OUT.Proj.w,0.5*OUT.Proj.w-OUT.Proj.y*0.5,OUT.Proj.z*0.5,OUT.Proj.w);
	float2 UV=float2(IN.Pos.x,-IN.Pos.y)*0.5+0.5;
	float FrameTime=IN.Tex0.x*IN.Tex0.y;
	FrameTime *=Particle.w*(1.0-(1.0/FrameTime));
	OUT.Tex.xy=UV+(float2(int(FrameTime),int(FrameTime/IN.Tex0.x))/IN.Tex0);
 	OUT.Tex.zw=UV+(float2(int(FrameTime+1.0),int((FrameTime+1.0)/IN.Tex0.x))/IN.Tex0);
	OUT.Frame=FrameTime-floor(FrameTime);
	OUT.Color=tex2Dlod(ColorSampler,float4(Particle.w*0.5,(IN.Tex6.x+0.5)/1024.0,0.0,0.0));
	OUT.Color.xyz=pow(OUT.Color.xyz+IN.Color,2.2);
	float4 ShadowProj=mul(float4(WorldPos,1.0),LightDirectionShadow)*float4(0.5,-0.5,1.0,0.0)+float4(0.5,0.5,0.0,0.0);
	float4 ShadowMap=float4(tex2Dlod(ShadowSampler,ShadowProj).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0,0.0009765625,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0009765625,0.0,0.0)).x);
	ShadowMap=saturate(step(ShadowProj.z,ShadowMap)+(1.0-ceil(ShadowMap)));
	ShadowMap.xy=lerp(ShadowMap.xz,ShadowMap.yw,frac(1024.0*ShadowProj.x));
	OUT.Lighting.xyz=LightDirectionColor*lerp(ShadowMap.x,ShadowMap.y,frac(1024*ShadowProj.y));
	float LightSegment=clamp(floor(length(ViewVec/LightRange)*16.0),0.0,15.0)*0.0078125;
	int LightCount=tex2Dlod(LightsSampler,float4(0.0,LightSegment,0.0,0.0));
	for (int l=0; l < LightCount; l++) {
	 float LightId=tex2Dlod(LightsSampler,float4((1.0+l)*0.0078125,LightSegment,0.0,0.0))*0.0078125;
	 float4 LightPosition=tex2Dlod(LightsSampler,float4(LightId,0.125,0.0,0.0));
	 float4 LightColor=tex2Dlod(LightsSampler,float4(LightId,0.1328125,0.0,0.0));
	 float4 LightSpot=tex2Dlod(LightsSampler,float4(LightId,0.140625,0.0,0.0));
	 float3 LightVec=LightPosition.xyz-WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float Light=saturate((dot(LightVec,LightSpot.xyz)-LightSpot.w)/LightColor.w);
	 OUT.Lighting.xyz +=LightColor.xyz*Light*max(1.0/(Attenuation/LightPosition.w)-1.0,0.0);
	}
	for (int l=0; l < DynamicPointCount; l++) {
	 float3 LightVec=float3(PointPositionX[l],PointPositionY[l],PointPositionZ[l])-WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 OUT.Lighting.xyz +=float3(PointRed[l],PointGreen[l],PointBlue[l])*max(1.0/(Attenuation/PointRange[l])-1.0,0.0);
	}
	for (int l=0; l < DynamicSpotCount; l++) {
	 float3 LightVec=float3(SpotPositionX[l],SpotPositionY[l],SpotPositionZ[l])-WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(SpotRed[l],SpotGreen[l],SpotBlue[l])*max(1.0/(Attenuation/SpotRange[l])-1.0,0.0);
	 OUT.Lighting.xyz +=Light*saturate((dot(LightVec,float3(SpotDirX[l],SpotDirY[l],SpotDirZ[l]))-SpotMin[l])/SpotMax[l]);
	}
	OUT.Lighting.w=IN.Tex4.y*Curve.x*32.0;
	OUT.Softness=IN.Tex5.y;
	OUT.Color.w *=saturate(exp(-((OUT.Pos.z*0.5)/FogColor.w)));
	return OUT;
     }
   OutPut VS_Distortion(InPut IN) 
     {
 	OutPut OUT;
	float2 Pixel=floor(float2(IN.Pos.z,IN.Pos.z/254.0));
	Pixel=float2((Pixel.x-Pixel.y*254.0)-256.0,Pixel.y+256.0)*0.00390625;
	float4 Particle=tex2Dlod(PixelSampler,float4(Pixel.x*0.5,Pixel.y,0.0,0.0));
	float4 ParticlePrevious=tex2Dlod(PixelSampler,float4(0.5+Pixel.x*0.5,Pixel.y,0.0,0.0));
	float3 WorldPos=Particle.xyz*IN.Tex5.x;
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Curve=tex2Dlod(ColorSampler,float4(0.5+Particle.w*0.5,(IN.Tex6.x+0.5)/1024.0,0.0,0.0));
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
	float2 PreviousPos=mul(float4(ParticlePrevious.xyz*IN.Tex5.x,1.0),ViewProj);
	PreviousPos=(OUT.Pos.xy-PreviousPos)/Aspect;
	float Dirlength=1.0+length(PreviousPos*IN.Tex1.y)/(saturate(Particle.w-ParticlePrevious.w)*IN.Tex5.x);
	float2 Size=(IN.Pos.xy*IN.Tex1.x)*Curve.y;
	float Strobe=saturate(sin(Particle.w*IN.Tex4.x).xx+0.5);
	Size +=Strobe*(IN.Pos.xy*IN.Tex3.y)*Curve.z;
	Size *=1.0+OUT.Pos.z*IN.Tex2.x;
	float Angle=lerp(IN.Tex2.y+(Particle.w*IN.Tex3.x),atan2(PreviousPos.x/OUT.Pos.w,PreviousPos.y/OUT.Pos.w),sign(IN.Tex1.y));
	Size=mul(float2(Size.x,Size.y*Dirlength*Dirlength),float2x2(cos(Angle),-sin(Angle),sin(Angle),cos(Angle)));
	OUT.Pos.xy +=Size*IN.Tex5.x*Aspect*ceil(saturate(Particle.w));
	OUT.Proj=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z*0.5,OUT.Pos.w);
	float2 UV=float2(IN.Pos.x,-IN.Pos.y)*0.5+0.5;
	float FrameTime=IN.Tex0.x*IN.Tex0.y;
	FrameTime *=Particle.w*(1.0-(1.0/FrameTime));
	OUT.Tex.xy=UV+(float2(int(FrameTime),int(FrameTime/IN.Tex0.x))/IN.Tex0);
 	OUT.Tex.zw=UV+(float2(int(FrameTime+1.0),int((FrameTime+1)/IN.Tex0.x))/IN.Tex0);
	OUT.Frame=FrameTime-floor(FrameTime);
	OUT.Color=tex2Dlod(ColorSampler,float4(Particle.w*0.5,(IN.Tex6.x+0.5)/1024.0,0.0,0.0));
	OUT.Lighting=0.0;
	OUT.Softness=0.0;
	return OUT;
     }

//--------------
// pixel shader
//--------------
    float4 PS_Lighting(OutPut IN)  : COLOR
     {
	float Depth=tex2D(DepthSampler,(IN.Proj.xy/IN.Proj.w)+ViewSize).w-IN.Proj.z;
        float4 Particle=lerp(tex2D(ParticleSampler,IN.Tex.xy),tex2D(ParticleSampler,IN.Tex.zw),IN.Frame);
        Particle.xyz=pow(Particle.xyz,2.2)*IN.Color.xyz;
	return float4(Particle.xyz*IN.Lighting.xyz+Particle.xyz*IN.Lighting.w,saturate(Depth*IN.Softness)*Particle.w*IN.Color.w);
    }
    float4 PS_Distortion(OutPut IN)  : COLOR
     {
	float Depth=saturate(tex2D(DepthSampler,(IN.Proj.xy/IN.Proj.w)+ViewSize).w-IN.Proj.z);
	return float4(0.5,0.5,1.0,Depth*lerp(tex2D(ParticleSampler,IN.Tex.xy).w,tex2D(ParticleSampler,IN.Tex.zw).w,IN.Frame)*IN.Color.w);
     }

//--------------
// techniques   
//--------------
   technique Lighting
      {
 	pass p0
      {		
	vertexShader= compile vs_3_0 VS_Lighting();
 	pixelShader = compile ps_3_0 PS_Lighting();
        ColorWriteEnable=7;
	AlphaBlendEnable=true;
	zwriteenable=false;
      }
      }
    technique Distortion
      {
 	pass p1
      {
 	vertexShader = compile vs_3_0 VS_Distortion();
 	pixelShader  = compile ps_3_0 PS_Distortion();
        ColorWriteEnable=7;
	AlphaBlendEnable=true;
	zwriteenable=false;
      }
      }

