// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 View:View;
   float4x4 Project:Projection;
   float4x4 ViewProj:ViewProjection; 
   float4x4 ViewInv:ViewInverse;

//--------------
// tweaks
//--------------
   float4 ViewSize;
   float Density;
   float3 SkyColor;
   float4 SkyTotal;
   float4 NightColor;
   float3 SunDirection;
   float3 SunScale;
   float SunIntensity;
   float4 AbsorptionSun;
   float3 LightColor1;
   float3 LightColor2;
   float3 CloudColor;
   float2 CloudScale;
   float4x4 MoonProj;
   float3x3 StarsAngle;

//--------------
// Textures
//--------------
   texture CloudTexture <string Name=""; >;
   sampler CloudSampler=sampler_state 
      {
	Texture=<CloudTexture>;
      };
   texture MoonTexture <string Name = "";>;	
   sampler MoonSampler=sampler_state 
      {
 	texture=<MoonTexture>;
	AddressU=Border;
	AddressV=Border;
      };
   texture StarsTexture <string Name="";>;
   sampler StarsSampler=sampler_state
      {
	texture=<StarsTexture>;
      };
   texture CloudVolumetricTexture <string Name=""; >;
   sampler CloudVolumetricSampler=sampler_state 
      {
	Texture=<CloudVolumetricTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
      };
   texture DepthTexture <string Name = "";>;	
   sampler DepthSampler=sampler_state 
      {
 	Texture=<DepthTexture>;
      	ADDRESSU=CLAMP;
        ADDRESSV=CLAMP;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };

//--------------
// structs 
//--------------
   struct Input
     {
        float4 Pos:POSITION;
     };
   struct Out_Lighting
     {
 	float4 Pos:POSITION; 
	float3 WorldPos:TEXCOORD0;
 	float3 ViewVec:TEXCOORD1;
   	float4 Proj:TEXCOORD2;
   	float4 Moon:TEXCOORD3;
	float3 Stars:TEXCOORD4;
     };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN) 
     {
 	Out_Lighting OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
	OUT.WorldPos=WorldPos;
	float3 ViewVec=WorldPos-ViewInv[3].xyz;
	OUT.ViewVec=ViewVec;
        OUT.Proj=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z*0.5,OUT.Pos.w);
        float4 MoonProj=mul(float4(ViewVec,1.0),MoonProj);
	OUT.Moon=float4(MoonProj.x*0.5+0.5*MoonProj.w,0.5*MoonProj.w-MoonProj.y*0.5,MoonProj.z,MoonProj.w);
	OUT.Stars=mul(IN.Pos,StarsAngle);
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting(Out_Lighting IN) : COLOR
     {
	float3 Normals=normalize(float3(IN.ViewVec.x,IN.WorldPos.y,IN.ViewVec.z));
	float2 CloudUv=(IN.ViewVec.xz/IN.ViewVec.y)/CloudScale;
	float Clouds=tex2Dlod(CloudSampler,CloudUv.xyyy).x*tex2Dlod(CloudSampler,CloudUv.xyyy*0.1).y*max(Normals.y,0.0);
	float4 Moon=tex2Dlod(MoonSampler,IN.Moon/IN.Moon.w)*saturate(IN.Moon.z);
	float3 Stars=texCUBE(StarsSampler,IN.Stars)+(NightColor.xyz*0.4);
	float SunDir=length(Normals-SunDirection);
	float Horizon=1.0-saturate(exp(-Normals.y*25.0));
	float Zenith=Density/pow(max(Normals.y,0.0035),0.75);
	float3 Absorption=exp2(SkyColor*-Zenith);
  	float Rayleigh=1.0+(1.0-(0.5+SunDir*0.5))*1.5707963268;
	float3 Sky=SkyColor*Rayleigh*Zenith;
	float3 Sun=SunIntensity*Absorption*smoothstep(SunScale.x,SunScale.y,SunDir)*SunScale.z*Horizon*(1.0-Moon.w);
	float Disk=saturate(1.0-pow(SunDir,0.1));
	float3 Mie=AbsorptionSun.xyz*Disk*Disk*(3.0-2.0*Disk)*3.14159265359;
	Sky=(SkyTotal*(lerp(Sky*Absorption,Sky/(Sky+0.25),AbsorptionSun.w)+Mie+Sun));
	Sky +=pow(lerp(Stars,Moon.xyz,Moon.w),2.2)*max(Normals.y*2,0.0)*(1.0-SkyTotal.w);
	float4 CloudColors=lerp(NightColor,AbsorptionSun,SkyTotal.w);
	float3 CloudVolumetric=tex2Dlod(CloudVolumetricSampler,(IN.Proj/IN.Proj.w)+ViewSize);
	CloudVolumetric.z=saturate(CloudVolumetric.z*1.1);
	Sky=lerp(Sky,CloudColors.xyz,Clouds)*(1.0-CloudVolumetric.z);
	Sky +=(CloudColor*CloudVolumetric.z+LightColor1*CloudVolumetric.y+LightColor2*CloudVolumetric.x)*2.0;
	return float4(Sky,64000.0);
     }
   float4 PS_Reflection(Out_Lighting IN) : COLOR
     {
	float3 Normals=normalize(float3(IN.ViewVec.x,IN.WorldPos.y,IN.ViewVec.z));
	float2 CloudUv=(IN.ViewVec.xz/IN.ViewVec.y)/CloudScale;
	float Clouds=tex2Dlod(CloudSampler,CloudUv.xyyy).x*tex2Dlod(CloudSampler,CloudUv.xyyy*0.1).y*max(Normals.y,0.0);
	float4 Moon=tex2Dlod(MoonSampler,IN.Moon/IN.Moon.w)*saturate(IN.Moon.z);
	float3 Stars=texCUBE(StarsSampler,IN.Stars)+(NightColor.xyz*0.4);
	float SunDir=length(Normals-SunDirection);
	float Horizon=1.0-saturate(exp(-Normals.y*25.0));
	float Zenith=Density/pow(max(Normals.y,0.0035),0.75);
	float3 Absorption=exp2(SkyColor*-Zenith);
  	float Rayleigh=1.0+(1.0-(0.5+SunDir*0.5))*1.5707963268;
	float3 Sky=SkyColor*Rayleigh*Zenith;
	float3 Sun=SunIntensity*Absorption*smoothstep(SunScale.x,SunScale.y,SunDir)*SunScale.z*Horizon*(1.0-Moon.w);
	float Disk=saturate(1.0-pow(SunDir,0.1));
	float3 Mie=AbsorptionSun.xyz*Disk*Disk*(3.0-2.0*Disk)*3.14159265359;
	Sky=(SkyTotal*(lerp(Sky*Absorption,Sky/(Sky+0.25),AbsorptionSun.w)+Mie+Sun));
	Sky +=pow(lerp(Stars,Moon.xyz,Moon.w),2.2)*max(Normals.y*2,0)*(1.0-SkyTotal.w);
	float4 CloudColors=lerp(NightColor,AbsorptionSun,SkyTotal.w);
	Sky=lerp(Sky,CloudColors.xyz,Clouds);
	float MaxComponent=max(max(Sky.x,Sky.y),Sky.z);
	float fExp=ceil(log(MaxComponent)/log(1.04));
	fExp=saturate((fExp+128.0)/255.0);
	return float4(Sky/pow(1.04,fExp*255.0-128.0),fExp);
     }
   float4 PS_Distortion(Out_Lighting IN) : COLOR
     {
	float4 Proj=(IN.Proj/IN.Proj.w)+ViewSize.xyyy;
	float3 Normals=normalize(float3(IN.ViewVec.x,IN.WorldPos.y,IN.ViewVec.z));
	float Light=max(dot(SunDirection,Normals),0.0);
	Light=1.0-(0.2+pow(Light,16.0)*0.8);
	Light=lerp(Light,1.0,tex2Dlod(CloudVolumetricSampler,Proj).z);
	if(tex2Dlod(DepthSampler,Proj).w<64000.0) Light=1.0;
	return float4(0.5,0.5,Light,1.0);
     }

//--------------
// techniques   
//-------------- 
   technique Lighting
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS_Lighting();
 	pixelShader  = compile ps_3_0 PS_Lighting();
	zwriteenable=false;
	CullMode=cw;
      }
      }
   technique Reflection
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS_Lighting();
 	pixelShader  = compile ps_3_0 PS_Reflection();
	ClipPlaneEnable=1;
	zwriteenable=false;
	CullMode=ccw;
      }
      }
   technique Distortion
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS_Lighting();
 	pixelShader  = compile ps_3_0 PS_Distortion();
	ColorWriteEnable=7;
	zwriteenable=false;
	CullMode=cw;
      }
      }
