// By EVOLVED
// www.evolved-software.com

#define Shadows 1
#define Specularity 1
#define ParallaxReflection 1

//--------------
// un-tweaks
//--------------
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 World:World;   
   float4x4 ViewInv:ViewInverse; 
   float4x4 ViewProj:ViewProjection; 

//--------------
// tweaks
//--------------
   float4 FogColor;
   float4 WaterFogColor;
   float WaterFogHeight;
   float3 AmbientColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float4x4 LightDirectionShadow;
   float4x4 ShadowProj;
   float4x4 LightProjMatrix1;
   float4 LightPosition1;
   float4 LightMask1;
   float4x4 LightProjMatrix2;
   float4 LightPosition2;
   float4 LightMask2;
   float4 ShadowPosition;
   float4 ShadowBlur={0.00146969383,0.00189736659,0.00224499442,0.0025455844};
   float4 ShadowNoise;
   float LightRange;
   int DynamicPointCount=0;
   float4 PointPositionX;
   float4 PointPositionY;
   float4 PointPositionZ;
   float4 PointRange;
   float4 PointRed;
   float4 PointGreen;
   float4 PointBlue;
   int DynamicSpotCount=0;
   float4 SpotPositionX;
   float4 SpotPositionY;
   float4 SpotPositionZ;
   float4 SpotRange;
   float4 SpotRed;
   float4 SpotGreen;
   float4 SpotBlue;
   float4 SpotDirX;
   float4 SpotDirY;
   float4 SpotDirZ;
   float4 SpotMin;
   float4 SpotMax;
   float Normalz=0.75;

//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;	
   sampler BaseSampler=sampler_state 
      {
 	Texture=<BaseTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=8;
      };
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	Texture=<NormalMapTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=4;
      };
   texture SecondarysTexture <string Name = "";>;	
   sampler SecondarysSampler=sampler_state 
      {
 	Texture=<SecondarysTexture>;
      };
   texture ReflectionTexture <string Name="";>;
   sampler ReflectionSampler=sampler_state
      {
	Texture=<ReflectionTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
	AddressW=Clamp;
      };
   texture LightsTexture <string Name = "";>;	
   sampler LightsSampler=sampler_state 
      {
 	Texture=<LightsTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };
   texture ShadowTexture <string Name = "";>;	
   sampler ShadowSampler=sampler_state 
      {
 	Texture=<ShadowTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture ShadowMapTexture <string Name = "";>;	
   sampler ShadowMapSampler=sampler_state 
      {
 	Texture=<ShadowMapTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
	AddressW=Clamp;
      };

//--------------
// structs 
//--------------
   struct Input
     {
 	float4 Pos:POSITION;
    	float2 Tex0:TEXCOORD; 
 	float3 Normal:NORMAL;
 	float3 Tangent:TANGENT;
      };
   struct Out_Lighting
      {
	float4 Pos:POSITION;
 	float4 Tex:TEXCOORD0;
  	float4 WorldPos:TEXCOORD1;
  	float4 TBNRow1:TEXCOORD2;
  	float4 TBNRow2:TEXCOORD3;
  	float4 TBNRow3:TEXCOORD4;
 	float4 LightX:TEXCOORD5;
  	float4 LightY:TEXCOORD6;
  	float4 LightZ:TEXCOORD7;
	float4 ShadowProj:COLOR0;
	float3 Depth:COLOR1;
      };
   struct Out_Depth
     {
 	float4 Pos:POSITION; 
 	float2 Tex:TEXCOORD0; 
 	float3 Depth:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN)  
     {
 	Out_Lighting OUT;
  	OUT.Pos=mul(IN.Pos,WorldVP);
	OUT.Tex.xy=IN.Tex0;
	OUT.Tex.zw=float2(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5);
	float3 WorldPos=mul(IN.Pos,World);
	OUT.WorldPos=float4(WorldPos,OUT.Pos.w);
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Normals=normalize(mul(IN.Normal,World)); 
	float3 Tangent=normalize(mul(IN.Tangent,World));
	OUT.TBNRow1.xyz=Tangent;
	OUT.TBNRow2.xyz=cross(Normals,Tangent);
	OUT.TBNRow3.xyz=Normals;
	float4 ShadowProj=mul(float4(WorldPos,1),LightDirectionShadow)*float4(0.5,-0.5,1,0)+float4(0.5,0.5,0.0,0.0);
	float4 ShadowMap=float4(tex2Dlod(ShadowSampler,ShadowProj).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0,0,0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0,0.0009765625,0,0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0009765625,0,0)).x);
	ShadowMap=saturate(step(ShadowProj.z-0.0005,ShadowMap)+(1-ceil(ShadowMap)));
	ShadowMap.xy=lerp(ShadowMap.xz,ShadowMap.yw,frac(1024*ShadowProj.x));
	float3 LightingColor=max(dot(LightDirection,Normals),0.0)*LightDirectionColor*lerp(ShadowMap.x,ShadowMap.y,frac(1024*ShadowProj.y));
	OUT.LightX.xyz=LightingColor*LightDirection.x, OUT.LightY.xyz=LightingColor*LightDirection.y, OUT.LightZ.xyz=LightingColor*LightDirection.z;
	float LightSegment=clamp(floor(length(ViewVec/LightRange)*16),0,15)*0.0078125;
	int LightCount=tex2Dlod(LightsSampler,float4(0.0,LightSegment,0.0,0.0));
	for (int l=0; l < LightCount; l++) {
	 float LightId=tex2Dlod(LightsSampler,float4((1.0+l)*0.0078125,LightSegment,0.0,0.0))*0.0078125;
	 float4 LightPosition=tex2Dlod(LightsSampler,float4(LightId,0.125,0.0,0.0));
	 float4 LightColor=tex2Dlod(LightsSampler,float4(LightId,0.1328125,0.0,0.0));
	 float4 LightSpot=tex2Dlod(LightsSampler,float4(LightId,0.140625,0.0,0.0));
	 float3 LightVec=LightPosition.xyz-WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float Light=max(dot(LightVec,Normals),0.0);
	 Light *=saturate((dot(LightVec,LightSpot.xyz)-LightSpot.w)/LightColor.w);
	 float3 LightingColor=LightColor.xyz*Light*max(1/(Attenuation/LightPosition.w)-1,0);
         OUT.LightX.xyz +=LightingColor*LightVec.x, OUT.LightY.xyz +=LightingColor*LightVec.y, OUT.LightZ.xyz +=LightingColor*LightVec.z;
	}
	#if ParallaxReflection == 0
	 OUT.TBNRow1.w=0.0, OUT.TBNRow2.w=0.0, OUT.TBNRow3.w=0.0;
	 OUT.LightX.w=0.0, OUT.LightY.w=0.0, OUT.LightZ.w=0.0;
	#else
	 float4 MinMaxX=tex2Dlod(ReflectionSampler,float4(0.0,0.0,0.0,0.0));
	 float4 MinMaxY=tex2Dlod(ReflectionSampler,float4(0.5,0.0,0.0,0.0));
	 float4 MinMaxZ=tex2Dlod(ReflectionSampler,float4(1.0,0.0,0.0,0.0));
	 float3 BoxMin=float3(MinMaxX.x,MinMaxY.x,MinMaxZ.x)*65025.0+float3(MinMaxX.y,MinMaxY.y,MinMaxZ.y)*255.0;
	 float3 BoxMax=float3(MinMaxX.z,MinMaxY.z,MinMaxZ.z)*65025.0+float3(MinMaxX.w,MinMaxY.w,MinMaxZ.w)*255.0;
	 BoxMin=(BoxMin-32512.0)*4.0;
	 OUT.TBNRow1.w=BoxMin.x, OUT.TBNRow2.w=BoxMin.y, OUT.TBNRow3.w=BoxMin.z;
	 BoxMax=(BoxMax-32512.0)*4.0;
	 OUT.LightX.w=BoxMax.x, OUT.LightY.w=BoxMax.y, OUT.LightZ.w=BoxMax.z;
	#endif
      	float4 ShadowProj1=mul(float4(WorldPos+Normals*2,1.0),LightProjMatrix1);
      	float4 ShadowProj2=mul(float4(WorldPos+Normals*2,1.0),LightProjMatrix2);
        OUT.ShadowProj.xy=float2(ShadowProj1.x*0.5+0.5*ShadowProj1.w,0.5*ShadowProj1.w-ShadowProj1.y*0.5);
        OUT.ShadowProj.zw=float2(ShadowProj2.x*0.5+0.5*ShadowProj2.w,0.5*ShadowProj2.w-ShadowProj2.y*0.5);
        OUT.Depth.xy=float2(ShadowProj1.w,ShadowProj2.w);
        OUT.Depth.z=OUT.Pos.z*0.5;
	return OUT;
     }
   Out_Lighting VS_Reflection(Input IN)  
     {
 	Out_Lighting OUT;
  	OUT.Pos=mul(IN.Pos,WorldVP);
	OUT.Tex.xy=IN.Tex0;
	OUT.Tex.zw=float2(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5);
	float3 WorldPos=mul(IN.Pos,World);
	OUT.WorldPos=float4(WorldPos,OUT.Pos.w);
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Normals=normalize(mul(IN.Normal,World));
	OUT.TBNRow1.xyz=0.0;
	OUT.TBNRow2.xyz=0.0;
	OUT.TBNRow3.xyz=Normals;
	float4 ShadowProj=mul(float4(WorldPos,1),LightDirectionShadow)*float4(0.5,-0.5,1,0)+float4(0.5,0.5,0.0,0.0);
	float4 ShadowMap=float4(tex2Dlod(ShadowSampler,ShadowProj).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0,0.0009765625,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0009765625,0.0,0.0)).x);
	ShadowMap=saturate(step(ShadowProj.z,ShadowMap)+(1.0-ceil(ShadowMap)));
	ShadowMap.xy=lerp(ShadowMap.xz,ShadowMap.yw,frac(1024*ShadowProj.x));
	float3 LightingColor=max(dot(LightDirection,Normals),0.0)*LightDirectionColor*lerp(ShadowMap.x,ShadowMap.y,frac(1024*ShadowProj.y));
	OUT.LightX.xyz=LightingColor*LightDirection.x, OUT.LightY.xyz=LightingColor*LightDirection.y, OUT.LightZ.xyz=LightingColor*LightDirection.z;
	float LightSegment=clamp(floor(length(ViewVec/LightRange)*16.0),0.0,15.0)*0.0078125;
	int LightCount=tex2Dlod(LightsSampler,float4(0.0,LightSegment,0.0,0.0));
	for (int l=0; l < LightCount; l++) {
	 float LightId=tex2Dlod(LightsSampler,float4((1.0+l)*0.0078125,LightSegment,0.0,0.0))*0.0078125;
	 float4 LightPosition=tex2Dlod(LightsSampler,float4(LightId,0.125,0.0,0.0));
	 float4 LightColor=tex2Dlod(LightsSampler,float4(LightId,0.1328125,0.0,0.0));
	 float4 LightSpot=tex2Dlod(LightsSampler,float4(LightId,0.140625,0.0,0.0));
	 float3 LightVec=LightPosition.xyz-WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float Light=max(dot(LightVec,Normals),0.0);
	 Light *=saturate((dot(LightVec,LightSpot.xyz)-LightSpot.w)/LightColor.w);
	 float3 LightingColor=LightColor.xyz*Light*max(1.0/(Attenuation/LightPosition.w)-1.0,0.0);
         OUT.LightX.xyz +=LightingColor*LightVec.x, OUT.LightY.xyz +=LightingColor*LightVec.y, OUT.LightZ.xyz +=LightingColor*LightVec.z;
	}
	OUT.TBNRow1.w=0.0, OUT.TBNRow2.w=0.0, OUT.TBNRow3.w=0.0;
	OUT.LightX.w=0.0, OUT.LightY.w=0.0, OUT.LightZ.w=0.0;
        OUT.ShadowProj=0.0;
        OUT.Depth.xy=0.0;
        OUT.Depth.z=OUT.Pos.z*0.5;
	return OUT;
     }
   Out_Depth VS_DepthMap(Input IN)
     {
        Out_Depth OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
 	OUT.Tex.xy=IN.Tex0;
	OUT.Depth=WorldPos.xyz-ShadowPosition.xyz;
        return OUT;
     }
   Out_Depth VS_DepthMapDir(Input IN)
     {
        Out_Depth OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1.0),ShadowProj);
 	OUT.Tex.xy=IN.Tex0;
	OUT.Depth=OUT.Pos.zzz;
        return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting(Out_Lighting IN)  : COLOR
     {
	float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);
	float4 NormalMap=tex2D(NormalMapSampler,IN.Tex.xy);
	float4 Secondarys=tex2D(SecondarysSampler,IN.Tex.xy);
	float3x3 WorldTBN=float3x3(IN.TBNRow1.xyz,IN.TBNRow2.xyz,IN.TBNRow3.xyz);
	float3 Normals=normalize(mul(float3(NormalMap.yw*2.0-1.0,Normalz),WorldTBN));
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos.xyz);
	float ViewNormal=max(dot(ViewVec,Normals),0.0);
	Diffuse.xyz=pow(Diffuse.xyz,2.2);
	float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
	Specular +=(1.0-Specular)*(1.0-NormalMap.z)*pow(1.0-ViewNormal,5.0);
	#if Shadows == 1
 	 float Noise=frac(52.9829*frac(dot((IN.Tex.zw/IN.WorldPos.w)*ShadowNoise.xy,ShadowNoise.zw)));
	 float4 DiskSin=0.0, DiskCos=0.0;
	 sincos((Noise+float4(2.0,3.0,4.0,5.0))*2.4,DiskSin,DiskCos);
	 float4 Disk1=float4(DiskSin.x,DiskCos.x,DiskSin.y,DiskCos.y)*ShadowBlur.xxyy;
	 float4 Disk2=float4(DiskSin.z,DiskCos.z,DiskSin.w,DiskCos.w)*ShadowBlur.zzww;
	 IN.ShadowProj /=IN.Depth.xxyy;
	 float Depth=length(LightPosition1.xyz-IN.WorldPos.xyz)/LightPosition1.w;
	 float4 ShadowMap=float4(tex2D(ShadowMapSampler,IN.ShadowProj.xy+Disk1.xy).y,tex2D(ShadowMapSampler,IN.ShadowProj.xy+Disk1.zw).y,tex2D(ShadowMapSampler,IN.ShadowProj.xy+Disk2.xy).y,tex2D(ShadowMapSampler,IN.ShadowProj.xy+Disk2.zw).y);
         float4 SpotShadow=saturate(LightMask1+dot(step(Depth,ShadowMap),0.25));
	 Depth=length(LightPosition2.xyz-IN.WorldPos.xyz)/LightPosition2.w;
         ShadowMap=float4(tex2D(ShadowMapSampler,IN.ShadowProj.zw+Disk1.xy).z,tex2D(ShadowMapSampler,IN.ShadowProj.zw+Disk1.zw).z,tex2D(ShadowMapSampler,IN.ShadowProj.zw+Disk2.xy).z,tex2D(ShadowMapSampler,IN.ShadowProj.zw+Disk2.zw).z);
         SpotShadow *=saturate(LightMask2+dot(step(Depth,ShadowMap),0.25));
	#else
         float4 SpotShadow=1.0;
	#endif
	float3 Lighting=max(IN.LightX.xyz*Normals.x+IN.LightY.xyz*Normals.y+IN.LightZ.xyz*Normals.z,0.0);
	#if Specularity == 1
	 float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2.5);
	 float Denominator=Distribution.x-1.0;
	 float3 LightDirX=normalize(ViewVec+float3(IN.LightX.x,IN.LightY.x,IN.LightZ.x));
	 float3 LightDirY=normalize(ViewVec+float3(IN.LightX.y,IN.LightY.y,IN.LightZ.y));
	 float3 LightDirZ=normalize(ViewVec+float3(IN.LightX.z,IN.LightY.z,IN.LightZ.z));
	 float3 HalfVec=float3(dot(LightDirX,Normals),dot(LightDirY,Normals),dot(LightDirZ,Normals))*Denominator+1.0005;
	 HalfVec=(Distribution/(3.141592*HalfVec*HalfVec))*Lighting;
	 float3 LightSpecular=max(HalfVec.x,max(HalfVec.y,HalfVec.z))*Lighting;
	#else
	 float3 LightSpecular=0.0;
	#endif
	for (int l=0; l < DynamicPointCount; l++) {
	 float3 LightVec=float3(PointPositionX[l],PointPositionY[l],PointPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(PointRed[l],PointGreen[l],PointBlue[l])*max(dot(LightVec,Normals),0.0)*max(1.0/(Attenuation/PointRange[l])-1.0,0.0);
	 Lighting +=Light;
	 #if Specularity == 1
	  HalfVec.x=max(dot(normalize(LightVec+ViewVec),Normals),0.0)*Denominator+1.0005;
	  LightSpecular +=(Distribution/(3.141592*HalfVec.x*HalfVec.x))*Light;
	 #endif
	}
	for (int l=0; l < DynamicSpotCount; l++) {
	 float3 LightVec=float3(SpotPositionX[l],SpotPositionY[l],SpotPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(SpotRed[l],SpotGreen[l],SpotBlue[l])*max(dot(LightVec,Normals),0.0)*max(1.0/(Attenuation/SpotRange[l])-1.0,0.0)*SpotShadow[l];
	 Light *=saturate((dot(LightVec,float3(SpotDirX[l],SpotDirY[l],SpotDirZ[l]))-SpotMin[l])/SpotMax[l]);
	 Lighting +=Light;
	 #if Specularity == 1
	  HalfVec.x=max(dot(normalize(LightVec+ViewVec),Normals),0.0)*Denominator+1.0005;
	  LightSpecular +=(Distribution/(3.141592*HalfVec.x*HalfVec.x))*Light;
	 #endif
	}
	#if ParallaxReflection == 0
	 float3 ViewReflection=reflect(ViewVec,Normals);
        #else
	 float3 BoxMin=float3(IN.TBNRow1.w,IN.TBNRow2.w,IN.TBNRow3.w);
	 float3 BoxMax=float3(IN.LightX.w,IN.LightY.w,IN.LightZ.w);
	 float3 ViewReflection=reflect(-ViewVec,Normals);
	 float3 ReflectionBox=max((BoxMin-IN.WorldPos.xyz)/ViewReflection,(BoxMax-IN.WorldPos.xyz)/ViewReflection);
	 ViewReflection=IN.WorldPos.xyz+ViewReflection*min(min(ReflectionBox.x,ReflectionBox.y),ReflectionBox.z);
	 ViewReflection=-normalize(ViewReflection-(BoxMin+((BoxMax-BoxMin)*0.5)));
	#endif
	float2 Equirectangular=0.3183*float2(atan2(-ViewReflection.z,ViewReflection.x),acos(ViewReflection.y));
	float4 Reflections=tex2Dlod(ReflectionSampler,float4(Equirectangular.x*0.5+0.5,1.0025-Equirectangular.y,0.0,NormalMap.z*5.0));
	LightSpecular +=Reflections.xyz*pow(1.04,Reflections.w*255.0-128.0);
	Lighting +=AmbientColor*Secondarys.y;
	Lighting *=(1.0-Specular)*(1.0-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*32.0);
        float2 FogDist=saturate(1.0-exp(-(IN.Depth.z/float2(FogColor.w,WaterFogColor.w))));
        FogDist.y *=saturate(-IN.WorldPos.y+WaterFogHeight);
	return float4(lerp(lerp(Lighting,FogColor.xyz,FogDist.x),WaterFogColor.xyz,FogDist.y),ceil(Diffuse.w-0.25)*IN.Depth.z);
     }
   float4 PS_Reflection(Out_Lighting IN)  : COLOR
     {
	float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);
	float4 NormalMap=tex2D(NormalMapSampler,IN.Tex.xy);
	float4 Secondarys=tex2D(SecondarysSampler,IN.Tex.xy);
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos.xyz);
	float ViewNormal=max(dot(ViewVec,IN.TBNRow3.xyz),0.0);
	Diffuse.xyz=pow(Diffuse.xyz,2.2);
	float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
	Specular +=(1.0-Specular)*(1.0-NormalMap.z)*pow(1.0-ViewNormal,5.0);
	float3 Lighting=max(IN.LightX.xyz*IN.TBNRow3.x+IN.LightY.xyz*IN.TBNRow3.y+IN.LightZ.xyz*IN.TBNRow3.z,0.0);
	for (int l=0; l < DynamicPointCount; l++) {
	 float3 LightVec=float3(PointPositionX[l],PointPositionY[l],PointPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 Lighting +=float3(PointRed[l],PointGreen[l],PointBlue[l])*max(dot(LightVec,IN.TBNRow3.xyz),0.0)*max(1.0/(Attenuation/PointRange[l])-1.0,0.0);
	}
	for (int l=0; l < DynamicSpotCount; l++) {
	 float3 LightVec=float3(SpotPositionX[l],SpotPositionY[l],SpotPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(SpotRed[l],SpotGreen[l],SpotBlue[l])*max(dot(LightVec,IN.TBNRow3.xyz),0.0)*max(1.0/(Attenuation/SpotRange[l])-1.0,0.0);
	 Lighting +=Light*saturate((dot(LightVec,float3(SpotDirX[l],SpotDirY[l],SpotDirZ[l]))-SpotMin[l])/SpotMax[l]);
	}
	float3 ViewReflection=reflect(ViewVec,IN.TBNRow3.xyz);
	float2 Equirectangular=0.3183*float2(atan2(-ViewReflection.z,ViewReflection.x),acos(ViewReflection.y));
	float4 Reflections=tex2Dlod(ReflectionSampler,float4(Equirectangular.x*0.5+0.5,1.0025-Equirectangular.y,0.0,NormalMap.z*5.0));
	float3 LightSpecular=Reflections.xyz*pow(1.04,Reflections.w*255.0-128.0);
	Lighting +=AmbientColor*Secondarys.y;
	Lighting *=(1.0-Specular)*(1.0-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*32.0);
        float FogDist=saturate(1.0-exp(-(IN.Depth.z/FogColor.w)));
	Lighting=lerp(Lighting,FogColor.xyz,FogDist);
	float MaxComponent=max(max(Lighting.x,Lighting.y),Lighting.z);
	float fExp=ceil(log(MaxComponent)/log(1.04));
	fExp=saturate((fExp+128.0)/255.0);
	return float4(Lighting/pow(1.04,fExp*255.0-128.0),ceil(Diffuse.w-0.25)*fExp);
     }
   float4 PS_DepthMap(Out_Depth IN) : COLOR
     {
	return float4(0.01+length(IN.Depth/ShadowPosition.w).xxx,tex2D(BaseSampler,IN.Tex.xy).w);
     }
   float4 PS_DepthMapDir(Out_Depth IN) : COLOR
     {
	return float4(0.0001+IN.Depth,tex2D(BaseSampler,IN.Tex.xy).w);
     }

//--------------
// techniques
//--------------
    technique Lighting
      {
 	pass p1
      {		
 	vertexShader=compile vs_3_0 VS_Lighting(); 
 	pixelShader=compile ps_3_0 PS_Lighting();
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique Reflection
      {
 	pass p1
      {
 	vertexShader=compile vs_3_0 VS_Reflection();
 	pixelShader=compile ps_3_0 PS_Reflection();
	ClipPlaneEnable=1;
	CullMode=cw;
	AlphaBlendEnable=false;
   	AlphaRef=64;
      }
      }
    technique DepthMap0
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMap();
 	PixelShader=compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap1
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap2
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=2;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap3
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=4;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap4
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap5
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS_DepthMapDir();
 	PixelShader  = compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
   	AlphaRef=64;
	ZFunc=GreaterEqual;
	CullMode=cw;
      }
      }
    technique DepthMap6
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMap();
 	PixelShader=compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=2;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap7
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMap();
 	PixelShader=compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=4;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }