// By EVOLVED
// www.evolved-software.com

#define Shadows 1
#define Specularity 1

//--------------
// un-tweaks
//--------------
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 World:World;   
   float4x4 ViewInv:ViewInverse; 
   float4x4 ViewProj:ViewProjection; 

//--------------
// tweaks
//--------------
   float4 FogColor;
   float4 WaterFogColor;
   float WaterFogHeight;
   float3 AmbientColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float4x4 LightDirectionShadow;
   float4x4 ShadowProj;
   float4x4 LightProjMatrix1;
   float4 LightPosition1;
   float4 LightMask1;
   float4x4 LightProjMatrix2;
   float4 LightPosition2;
   float4 LightMask2;
   float4 ShadowPosition;
   float4 ShadowBlur={0.00146969383,0.00189736659,0.00224499442,0.0025455844};
   float4 ShadowNoise;
   float LightRange;
   int DynamicPointCount=0;
   float4 PointPositionX;
   float4 PointPositionY;
   float4 PointPositionZ;
   float4 PointRange;
   float4 PointRed;
   float4 PointGreen;
   float4 PointBlue;
   int DynamicSpotCount=0;
   float4 SpotPositionX;
   float4 SpotPositionY;
   float4 SpotPositionZ;
   float4 SpotRange;
   float4 SpotRed;
   float4 SpotGreen;
   float4 SpotBlue;
   float4 SpotDirX;
   float4 SpotDirY;
   float4 SpotDirZ;
   float4 SpotMin;
   float4 SpotMax;
   float Normalz=0.75;
   float4 TreeWindTimer=0;
   float4 TreeWindSize={2500,750,250,5};
   float3 TreeWindPower={10,5,2};

//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;	
   sampler BaseSampler=sampler_state 
      {
 	Texture=<BaseTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=8;
      };
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	Texture=<NormalMapTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=4;
      };
   texture SecondarysTexture <string Name = "";>;	
   sampler SecondarysSampler=sampler_state 
      {
 	Texture=<SecondarysTexture>;
      };
   texture ReflectionTexture <string Name="";>;
   sampler ReflectionSampler=sampler_state
      {
	Texture=<ReflectionTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
	AddressW=Clamp;
      };
   texture LightsTexture <string Name = "";>;	
   sampler LightsSampler=sampler_state 
      {
 	Texture=<LightsTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };
   texture ShadowTexture <string Name = "";>;	
   sampler ShadowSampler=sampler_state 
      {
 	Texture=<ShadowTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture ShadowMapTexture <string Name = "";>;	
   sampler ShadowMapSampler=sampler_state 
      {
 	Texture=<ShadowMapTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
	AddressW=Clamp;
      };

//--------------
// structs 
//--------------
   struct Input
     {
 	float4 Pos:POSITION;
    	float2 Tex0:TEXCOORD;
 	float2 Tex1:TEXCOORD1;
 	float2 Tex2:TEXCOORD2;
	float3 Normal:NORMAL;
  	float3 Color:COLOR0;
      };
   struct Out_Lighting
      {
	float4 Pos:POSITION;
 	float4 Tex:TEXCOORD0;
  	float4 WorldPos:TEXCOORD1;
  	float3 TBNRow1:TEXCOORD2;
  	float3 TBNRow2:TEXCOORD3;
  	float3 TBNRow3:TEXCOORD4;
 	float3 LightX:TEXCOORD5;
  	float3 LightY:TEXCOORD6;
  	float3 LightZ:TEXCOORD7;
	float3 Depth:COLOR0;
	float3 Translucency:COLOR1;
      };
   struct Out_Depth
     {
 	float4 Pos:POSITION; 
 	float2 Tex:TEXCOORD0; 
 	float3 Depth:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN)  
     {
 	Out_Lighting OUT;
	float3 WorldPos=mul(IN.Pos,World);
        OUT.WorldPos.xyz=WorldPos;
	float3 Normals=normalize(mul(IN.Normal,World));
	float4 ShadowProj=mul(float4(WorldPos,1.0),LightDirectionShadow)*float4(0.5,-0.5,1.0,0.0)+float4(0.5,0.5,0.0,0.0);
	float3 GlobalWind=(WorldPos.xyz/TreeWindSize.x)+TreeWindTimer.x;
	GlobalWind=float3(cos(GlobalWind.x),0.0,sin(GlobalWind.z));
	GlobalWind.y=1.0+abs(dot(GlobalWind.x,GlobalWind.z));
   	float3 WindForce=(WorldPos.xyz/TreeWindSize.x)+TreeWindTimer.y-GlobalWind;
	WindForce=float3(cos(WindForce.x),0.0,sin(WindForce.y));
	float3 WindAnimate=WindForce*TreeWindPower.x*(IN.Pos.y/TreeWindSize.y);
	float WindVariant=TreeWindTimer.z+(IN.Color.y*10.0);
	WindAnimate.xz +=float2(cos(WindVariant),sin(WindVariant))*TreeWindPower.y*IN.Color.z;
	float3 WindFlutter=(WorldPos.xyz/TreeWindSize.w)+(TreeWindTimer.w)+IN.Color.y;
	WindAnimate +=abs(Normals)*sin(dot(WindFlutter,1.0))*TreeWindPower.z*(IN.Color.x-0.5);
	WorldPos +=WindAnimate*GlobalWind.y;
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
	OUT.Tex.xy=IN.Tex0;
	OUT.Tex.zw=float2(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5);
	OUT.WorldPos.w=OUT.Pos.w;
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Tangent=normalize(mul(float3(IN.Tex1,IN.Tex2.x),World));
	OUT.TBNRow1=Tangent;
	OUT.TBNRow2=cross(Normals,Tangent);
	OUT.TBNRow3=Normals;
	float4 ShadowMap=float4(tex2Dlod(ShadowSampler,ShadowProj).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0,0.0009765625,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0009765625,0.0,0.0)).x);
	ShadowMap=saturate(step(ShadowProj.z-0.002,ShadowMap)+(1.0-ceil(ShadowMap)));
	ShadowMap.xy=lerp(ShadowMap.xz,ShadowMap.yw,frac(1024.0*ShadowProj.x));
	float3 LightingColor=max(dot(LightDirection,Normals),0.0)*LightDirectionColor*lerp(ShadowMap.x,ShadowMap.y,frac(1024.0*ShadowProj.y));
	OUT.LightX=LightingColor*LightDirection.x, OUT.LightY=LightingColor*LightDirection.y, OUT.LightZ=LightingColor*LightDirection.z;
	float LightSegment=clamp(floor(length(ViewVec/LightRange)*16.0),0.0,15.0)*0.0078125;
	int LightCount=tex2Dlod(LightsSampler,float4(0.0,LightSegment,0.0,0.0));
	for (int l=0; l < LightCount; l++) {
	 float LightId=tex2Dlod(LightsSampler,float4((1.0+l)*0.0078125,LightSegment,0.0,0.0))*0.0078125;
	 float4 LightPosition=tex2Dlod(LightsSampler,float4(LightId,0.125,0.0,0.0));
	 float4 LightColor=tex2Dlod(LightsSampler,float4(LightId,0.1328125,0.0,0.0));
	 float4 LightSpot=tex2Dlod(LightsSampler,float4(LightId,0.140625,0.0,0.0));
	 float3 LightVec=LightPosition.xyz-WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float Light=max(dot(LightVec,Normals),0.0);
	 Light *=saturate((dot(LightVec,LightSpot.xyz)-LightSpot.w)/LightColor.w);
	 float3 LightingColor=LightColor.xyz*Light*max(1.0/(Attenuation/LightPosition.w)-1.0,0.0);
         OUT.LightX +=LightingColor*LightVec.x, OUT.LightY +=LightingColor*LightVec.y, OUT.LightZ +=LightingColor*LightVec.z;
	}
        OUT.Depth.xy=0.0;
        OUT.Depth.z=OUT.Pos.z*0.5;
	ViewVec=normalize(ViewVec);
	OUT.Translucency=(0.5+dot(-LightDirection,Normals)*0.5)*dot(normalize(-LightDirection+ViewVec),ViewVec);
  	OUT.Translucency *=LightDirectionColor*lerp(ShadowMap.x,ShadowMap.y,frac(1024.0*ShadowProj.y));
  	OUT.Translucency=max(OUT.Translucency,0.0);
	return OUT;
     }
   Out_Lighting VS_Reflection(Input IN)  
     {
 	Out_Lighting OUT;
	float3 WorldPos=mul(IN.Pos,World);
	float4 ShadowProj=mul(float4(WorldPos,1.0),LightDirectionShadow)*float4(0.5,-0.5,1.0,0.0)+float4(0.5,0.5,0.0,0.0);
	float3 Normals=normalize(mul(IN.Normal,World));
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
	OUT.Tex.xy=IN.Tex0;
	OUT.Tex.zw=0.0;
	OUT.WorldPos=float4(WorldPos,0.0);
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Tangent=normalize(mul(float3(IN.Tex1,IN.Tex2.x),World));
	OUT.TBNRow1=0.0;
	OUT.TBNRow2=0.0;
	OUT.TBNRow3=Normals;
	float4 ShadowMap=float4(tex2Dlod(ShadowSampler,ShadowProj).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0,0.0009765625,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0009765625,0.0,0.0)).x);
	ShadowMap=saturate(step(ShadowProj.z+0.01,ShadowMap)+(1.0-ceil(ShadowMap)));
	ShadowMap.xy=lerp(ShadowMap.xz,ShadowMap.yw,frac(1024.0*ShadowProj.x));
	float3 LightingColor=max(dot(LightDirection,Normals),0.0)*LightDirectionColor*lerp(ShadowMap.x,ShadowMap.y,frac(1024.0*ShadowProj.y));
	OUT.LightX=LightingColor*LightDirection.x, OUT.LightY=LightingColor*LightDirection.y, OUT.LightZ=LightingColor*LightDirection.z;
	float LightSegment=clamp(floor(length(ViewVec/LightRange)*16.0),0.0,15.0)*0.0078125;
	int LightCount=tex2Dlod(LightsSampler,float4(0.0,LightSegment,0.0,0.0));
	for (int l=0; l < LightCount; l++) {
	 float LightId=tex2Dlod(LightsSampler,float4((1.0+l)*0.0078125,LightSegment,0.0,0.0))*0.0078125;
	 float4 LightPosition=tex2Dlod(LightsSampler,float4(LightId,0.125,0.0,0.0));
	 float4 LightColor=tex2Dlod(LightsSampler,float4(LightId,0.1328125,0.0,0.0));
	 float4 LightSpot=tex2Dlod(LightsSampler,float4(LightId,0.140625,0.0,0.0));
	 float3 LightVec=LightPosition.xyz-WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float Light=max(dot(LightVec,Normals),0.0);
	 Light *=saturate((dot(LightVec,LightSpot.xyz)-LightSpot.w)/LightColor.w);
	 float3 LightingColor=LightColor.xyz*Light*max(1.0/(Attenuation/LightPosition.w)-1.0,0.0);
         OUT.LightX +=LightingColor*LightVec.x, OUT.LightY +=LightingColor*LightVec.y, OUT.LightZ +=LightingColor*LightVec.z;
	}
        OUT.Depth.xy=0.0;
        OUT.Depth.z=OUT.Pos.z*0.5;
        OUT.Translucency=0.0;
	return OUT;
     }
   Out_Depth VS_DepthMap(Input IN)
     {
        Out_Depth OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
 	OUT.Tex.xy=IN.Tex0;
	OUT.Depth=WorldPos.xyz-ShadowPosition.xyz;
        return OUT;
     }
   Out_Depth VS_DepthMapDir(Input IN)
     {
        Out_Depth OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1.0),ShadowProj);
 	OUT.Tex.xy=IN.Tex0;
	OUT.Depth=OUT.Pos.zzz;
        return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting(Out_Lighting IN)  : COLOR
     {
	float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);
	float4 NormalMap=tex2D(NormalMapSampler,IN.Tex.xy);
	float4 Secondarys=tex2D(SecondarysSampler,IN.Tex.xy);
	float3x3 WorldTBN=float3x3(IN.TBNRow1,IN.TBNRow2,IN.TBNRow3);
	float3 Normals=normalize(mul(float3(NormalMap.yw*2.0-1.0,Normalz),WorldTBN));
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos.xyz);
	float ViewNormal=max(dot(ViewVec,Normals),0.0);
	Diffuse.xyz=pow(Diffuse.xyz,2.2);
	float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
	Specular +=(1.0-Specular)*(1.0-NormalMap.z)*pow(1.0-ViewNormal,5.0);
	float3 Lighting=max(IN.LightX*Normals.x+IN.LightY*Normals.y+IN.LightZ*Normals.z,0.0);
	#if Specularity == 1
	 float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2.5);
	 float Denominator=Distribution.x-1.0;
	 float3 LightDirX=normalize(ViewVec+float3(IN.LightX.x,IN.LightY.x,IN.LightZ.x));
	 float3 LightDirY=normalize(ViewVec+float3(IN.LightX.y,IN.LightY.y,IN.LightZ.y));
	 float3 LightDirZ=normalize(ViewVec+float3(IN.LightX.z,IN.LightY.z,IN.LightZ.z));
	 float3 HalfVec=float3(dot(LightDirX,Normals),dot(LightDirY,Normals),dot(LightDirZ,Normals))*Denominator+1.0005;
	 HalfVec=(Distribution/(3.141592*HalfVec*HalfVec))*Lighting;
	 float3 LightSpecular=max(HalfVec.x,max(HalfVec.y,HalfVec.z))*Lighting;
	#else
	 float3 LightSpecular=0.0;
	#endif
	for (int l=0; l < DynamicPointCount; l++) {
	 float3 LightVec=float3(PointPositionX[l],PointPositionY[l],PointPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(PointRed[l],PointGreen[l],PointBlue[l])*max(dot(LightVec,Normals),0.0)*max(1.0/(Attenuation/PointRange[l])-1.0,0.0);
	 Lighting +=Light;
	 #if Specularity == 1
	  HalfVec.x=max(dot(normalize(LightVec+ViewVec),Normals),0.0)*Denominator+1.0005;
	  LightSpecular +=(Distribution/(3.141592*HalfVec.x*HalfVec.x))*Light;
	 #endif
	}
	for (int l=0; l < DynamicSpotCount; l++) {
	 float3 LightVec=float3(SpotPositionX[l],SpotPositionY[l],SpotPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(SpotRed[l],SpotGreen[l],SpotBlue[l])*max(dot(LightVec,Normals),0.0)*max(1.0/(Attenuation/SpotRange[l])-1.0,0.0);
	 Light *=saturate((dot(LightVec,float3(SpotDirX[l],SpotDirY[l],SpotDirZ[l]))-SpotMin[l])/SpotMax[l]);
	 Lighting +=Light;
	 #if Specularity == 1
	  HalfVec.x=max(dot(normalize(LightVec+ViewVec),Normals),0.0)*Denominator+1.0005;
	  LightSpecular +=(Distribution/(3.141592*HalfVec.x*HalfVec.x))*Light;
	 #endif
	}
	float3 ViewReflection=reflect(ViewVec,Normals);
	float2 Equirectangular=0.3183*float2(atan2(-ViewReflection.z,ViewReflection.x),acos(ViewReflection.y));
	float4 Reflections=tex2Dlod(ReflectionSampler,float4(Equirectangular.x*0.5+0.5,1.0025-Equirectangular.y,0.0,NormalMap.z*5.0));
	LightSpecular +=Reflections.xyz*pow(1.04,Reflections.w*255.0-128.0);
	Lighting +=AmbientColor*Secondarys.y;
	Lighting *=(1.0-Specular)*(1.0-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*32.0);
	Lighting +=pow(Diffuse.xyz,0.5)*IN.Translucency*Secondarys.z;
        float2 FogDist=saturate(1.0-exp(-(IN.Depth.z/float2(FogColor.w,WaterFogColor.w))));
        FogDist.y *=saturate(-IN.WorldPos.y+WaterFogHeight);
	return float4(lerp(lerp(Lighting,FogColor.xyz,FogDist.x),WaterFogColor.xyz,FogDist.y),ceil(Diffuse.w-0.25)*IN.Depth.z);
     }
   float4 PS_Reflection(Out_Lighting IN)  : COLOR
     {
	float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);
	float4 NormalMap=tex2D(NormalMapSampler,IN.Tex.xy);
	float4 Secondarys=tex2D(SecondarysSampler,IN.Tex.xy);
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos.xyz);
	float ViewNormal=max(dot(ViewVec,IN.TBNRow3),0.0);
	Diffuse.xyz=pow(Diffuse.xyz,2.2);
	float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
	Specular +=(1.0-Specular)*(1.0-NormalMap.z)*pow(1.0-ViewNormal,5.0);
	float3 Lighting=max(IN.LightX.xyz*IN.TBNRow3.x+IN.LightY.xyz*IN.TBNRow3.y+IN.LightZ.xyz*IN.TBNRow3.z,0.0);
	float3 ViewReflection=reflect(ViewVec,IN.TBNRow3);
	float2 Equirectangular=0.3183*float2(atan2(-ViewReflection.z,ViewReflection.x),acos(ViewReflection.y));
	float4 Reflections=tex2Dlod(ReflectionSampler,float4(Equirectangular.x*0.5+0.5,1.0025-Equirectangular.y,0.0,NormalMap.z*5.0));
	float3 LightSpecular=Reflections.xyz*pow(1.04,Reflections.w*255.0-128.0);
	Lighting +=AmbientColor*Secondarys.y;
	Lighting *=(1.0-Specular)*(1.0-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*32.0);
        float FogDist=saturate(1.0-exp(-(IN.Depth.z/FogColor.w)));
	Lighting=lerp(Lighting,FogColor.xyz,FogDist);
	float MaxComponent=max(max(Lighting.x,Lighting.y),Lighting.z);
	float fExp=ceil(log(MaxComponent)/log(1.04));
	fExp=saturate((fExp+128.0)/255.0);
	return float4(Lighting/pow(1.04,fExp*255.0-128.0),ceil(Diffuse.w-0.25)*fExp);
     }
   float4 PS_DepthMap(Out_Depth IN) : COLOR
     {
	return float4(0.01+length(IN.Depth/ShadowPosition.w).xxx,tex2D(BaseSampler,IN.Tex.xy).w);
     }
   float4 PS_DepthMapDir(Out_Depth IN) : COLOR
     {
	return float4(0.0001+IN.Depth,tex2D(BaseSampler,IN.Tex.xy).w);
     }

//--------------
// techniques
//--------------
    technique Lighting
      {
 	pass p1
      {		
 	vertexShader=compile vs_3_0 VS_Lighting(); 
 	pixelShader=compile ps_3_0 PS_Lighting();
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique Reflection
      {
 	pass p1
      {
 	vertexShader=compile vs_3_0 VS_Reflection();
 	pixelShader=compile ps_3_0 PS_Reflection();
	ClipPlaneEnable=1;
	CullMode=cw;
	AlphaBlendEnable=false;
   	AlphaRef=64;
      }
      }
    technique DepthMap0
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMap();
 	PixelShader=compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap1
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap2
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=2;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap3
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=4;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap4
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap5
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS_DepthMapDir();
 	PixelShader  = compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
   	AlphaRef=64;
	ZFunc=GreaterEqual;
	CullMode=cw;
      }
      }
    technique DepthMap6
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMap();
 	PixelShader=compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=2;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap7
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMap();
 	PixelShader=compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=4;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }