// By EVOLVED
// www.evolved-software.com

#define Shadows 1
#define Specularity 1
#define ParallaxMapping 1
#define ParallaxReflection 1

//--------------
// un-tweaks
//--------------
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 World:World;   
   float4x4 ViewInv:ViewInverse; 
   float4x4 ViewProj:ViewProjection; 

//--------------
// tweaks
//--------------
   float4 FogColor;
   float4 WaterFogColor;
   float WaterFogHeight;
   float3 AmbientColor;
   float3 DirectionShadow;
   float4x4 DirectionShadowProj;
   float4x4 ShadowProj;
   float4x4 LightProjMatrix1;
   float4 LightPosition1;
   float4 LightMask1;
   float4x4 LightProjMatrix2;
   float4 LightPosition2;
   float4 LightMask2;
   float4 ShadowPosition;
   float4 ShadowBlur={0.00146969383,0.00189736659,0.00224499442,0.0025455844};
   float4 ShadowNoise;
   int DynamicPointCount=0;
   float4 PointPositionX;
   float4 PointPositionY;
   float4 PointPositionZ;
   float4 PointRange;
   float4 PointRed;
   float4 PointGreen;
   float4 PointBlue;
   int DynamicSpotCount=0;
   float4 SpotPositionX;
   float4 SpotPositionY;
   float4 SpotPositionZ;
   float4 SpotRange;
   float4 SpotRed;
   float4 SpotGreen;
   float4 SpotBlue;
   float4 SpotDirX;
   float4 SpotDirY;
   float4 SpotDirZ;
   float4 SpotMin;
   float4 SpotMax;
   float Normalz=0.75;
   float Heightvec=0.018;

//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;
   sampler BaseSampler=sampler_state 
      {
 	Texture=<BaseTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=8;
      };
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	Texture=<NormalMapTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=4;
      };
   texture SecondarysTexture <string Name = "";>;	
   sampler SecondarysSampler=sampler_state 
      {
 	Texture=<SecondarysTexture>;
      };
   texture ReflectionTexture <string Name="";>;
   sampler ReflectionSampler=sampler_state
      {
	Texture=<ReflectionTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
	AddressW=Clamp;
      };
   texture LightMapXTexture <string Name = "";>;	
   sampler LightMapXSampler=sampler_state 
      {
 	Texture=<LightMapXTexture>;
      };
   texture LightMapYTexture <string Name = "";>;	
   sampler LightMapYSampler=sampler_state 
      {
 	Texture=<LightMapYTexture>;
      };
   texture LightMapZTexture <string Name = "";>;	
   sampler LightMapZSampler=sampler_state 
      {
 	Texture=<LightMapZTexture>;
      };
   texture ShadowMapTexture <string Name="";>;
   sampler ShadowMapSampler=sampler_state
      {
	Texture=<ShadowMapTexture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };

//--------------
// structs 
//--------------
   struct Input
     {
 	float4 Pos:POSITION; 
	float3 Normal:NORMAL; 
	float3 Color:COLOR0;
	float2 Tex0:TEXCOORD0; 
 	float2 Tex1:TEXCOORD1; 
 	float2 Tex2:TEXCOORD2; 
	float2 Tex3:TEXCOORD3; 
      };
   struct Out_Lighting
      {
	float4 Pos:POSITION;
 	float4 Tex:TEXCOORD0;
	float4 Tex2:TEXCOORD1;
  	float4 WorldPos:TEXCOORD2;
  	float4 TBNRow1:TEXCOORD3;
  	float4 TBNRow2:TEXCOORD4; 
  	float4 TBNRow3:TEXCOORD5;
  	float4 ViewNor:TEXCOORD6;
  	float3 BoxMax:TEXCOORD7;
	float4 ShadowProj:COLOR0;
	float3 Depth:COLOR1;
       };
   struct Out_Depth
     {
 	float4 Pos:POSITION; 
 	float2 Tex:TEXCOORD0; 
 	float3 Depth:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN)  
     {
 	Out_Lighting OUT;
  	OUT.Pos=mul(IN.Pos,WorldVP);
	OUT.Tex.xy=IN.Tex0;
	OUT.Tex.zw=float2(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5);
	OUT.Tex2.xy=IN.Tex3;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.WorldPos=float4(WorldPos,OUT.Pos.w);
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Normals=normalize(mul(IN.Normal,World)); 
	float3 Tangent=normalize(mul(float3(IN.Tex1,IN.Tex2.x),World));
	OUT.TBNRow1.xyz=Tangent;
	OUT.TBNRow2.xyz=cross(Normals,Tangent);
	OUT.TBNRow3.xyz=Normals;
	float3x3 WorldTBN=float3x3(OUT.TBNRow1.xyz,OUT.TBNRow2.xyz,OUT.TBNRow3.xyz);
	OUT.ViewNor.xyz=mul(ViewVec,transpose(WorldTBN));
	float4 ShadowsProj=mul(float4(WorldPos,1.0),DirectionShadowProj)*float4(0.5,-0.5,1.0,0.0)+float4(0.5,0.5,0.0,0.0);
        OUT.Tex2.zw=ShadowsProj.xy;
        OUT.ViewNor.w=ShadowsProj.z;
	#if ParallaxReflection == 0
	 OUT.TBNRow1.w=0.0, OUT.TBNRow2.w=0.0, OUT.TBNRow3.w=0.0;
	 OUT.BoxMax=0.0;
	#else
	 float4 MinMaxX=tex2Dlod(ReflectionSampler,float4(0.0,0.0,0.0,0.0));
	 float4 MinMaxY=tex2Dlod(ReflectionSampler,float4(0.5,0.0,0.0,0.0));
	 float4 MinMaxZ=tex2Dlod(ReflectionSampler,float4(1.0,0.0,0.0,0.0));
	 float3 BoxMin=float3(MinMaxX.x,MinMaxY.x,MinMaxZ.x)*65025.0+float3(MinMaxX.y,MinMaxY.y,MinMaxZ.y)*255.0;
	 float3 BoxMax=float3(MinMaxX.z,MinMaxY.z,MinMaxZ.z)*65025.0+float3(MinMaxX.w,MinMaxY.w,MinMaxZ.w)*255.0;
	 BoxMin=(BoxMin-32512.0)*4.0;
	 OUT.TBNRow1.w=BoxMin.x, OUT.TBNRow2.w=BoxMin.y, OUT.TBNRow3.w=BoxMin.z;
	 OUT.BoxMax=(BoxMax-32512.0)*4.0;
	#endif
      	float4 ShadowProj1=mul(float4(WorldPos+Normals*2,1.0),LightProjMatrix1);
      	float4 ShadowProj2=mul(float4(WorldPos+Normals*2,1.0),LightProjMatrix2);
        OUT.ShadowProj.xy=float2(ShadowProj1.x*0.5+0.5*ShadowProj1.w,0.5*ShadowProj1.w-ShadowProj1.y*0.5);
        OUT.ShadowProj.zw=float2(ShadowProj2.x*0.5+0.5*ShadowProj2.w,0.5*ShadowProj2.w-ShadowProj2.y*0.5);
        OUT.Depth.xy=float2(ShadowProj1.w,ShadowProj2.w);
        OUT.Depth.z=OUT.Pos.z*0.5;
	return OUT;
     }
   Out_Lighting VS_Reflection(Input IN)  
     {
 	Out_Lighting OUT;
  	OUT.Pos=mul(IN.Pos,WorldVP);
	OUT.Tex.xy=IN.Tex0;
	OUT.Tex.zw=float2(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5);
	OUT.Tex2.xy=IN.Tex3;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.WorldPos=float4(WorldPos,OUT.Pos.w);
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Normals=normalize(mul(IN.Normal,World));
	OUT.TBNRow1.xyz=0.0;
	OUT.TBNRow2.xyz=0.0;
	OUT.TBNRow3.xyz=Normals;
	OUT.ViewNor=0.0;
        OUT.Tex2.zw=0.0;
	OUT.TBNRow1.w=0.0, OUT.TBNRow2.w=0.0, OUT.TBNRow3.w=0.0;
	OUT.BoxMax=0.0;
      	float4 ShadowProj1=mul(float4(WorldPos+Normals*2,1.0),LightProjMatrix1);
      	float4 ShadowProj2=mul(float4(WorldPos+Normals*2,1.0),LightProjMatrix2);
        OUT.ShadowProj.xy=float2(ShadowProj1.x*0.5+0.5*ShadowProj1.w,0.5*ShadowProj1.w-ShadowProj1.y*0.5);
        OUT.ShadowProj.zw=float2(ShadowProj2.x*0.5+0.5*ShadowProj2.w,0.5*ShadowProj2.w-ShadowProj2.y*0.5);
        OUT.Depth.xy=float2(ShadowProj1.w,ShadowProj2.w);
        OUT.Depth.z=OUT.Pos.z*0.5;
	return OUT;
     }
   Out_Depth VS_DepthMap(Input IN)
     {
        Out_Depth OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1.0),ViewProj);
 	OUT.Tex.xy=IN.Tex0;
	OUT.Depth=WorldPos.xyz-ShadowPosition.xyz;
        return OUT;
     }
   Out_Depth VS_DepthMapDir(Input IN)
     {
        Out_Depth OUT;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.Pos=mul(float4(WorldPos,1.0),ShadowProj);
 	OUT.Tex.xy=IN.Tex0;
	OUT.Depth=OUT.Pos.zzz;
        return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS_Lighting(Out_Lighting IN)  : COLOR
     {
	#if ParallaxMapping == 1
	 float3 ViewNor=normalize(IN.ViewNor.xyz);
	 IN.Tex.xy +=(Heightvec*(tex2D(SecondarysSampler,IN.Tex.xy).w-0.5))*ViewNor.xy;
	 IN.Tex.xy +=(Heightvec*(tex2D(SecondarysSampler,IN.Tex.xy).w-0.5))*ViewNor.xy;
	 IN.Tex.xy +=(Heightvec*(tex2D(SecondarysSampler,IN.Tex.xy).w-0.5))*ViewNor.xy;
	#endif
	float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);
	float4 NormalMap=tex2D(NormalMapSampler,IN.Tex.xy);
	float4 Secondarys=tex2D(SecondarysSampler,IN.Tex.xy);
	float3x3 WorldTBN=float3x3(IN.TBNRow1.xyz,IN.TBNRow2.xyz,IN.TBNRow3.xyz);
	float3 Normals=normalize(mul(float3(NormalMap.yw*2.0-1.0,Normalz),WorldTBN));
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos.xyz);
	float ViewNormal=max(dot(ViewVec,Normals),0.0);
	Diffuse.xyz=pow(Diffuse.xyz,2.2);
	float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
	Specular +=(1.0-Specular)*(1.0-NormalMap.z)*pow(1.0-ViewNormal,5.0);
	#if Shadows == 1
  	 float Noise=frac(52.9829*frac(dot((IN.Tex.zw/IN.WorldPos.w)*ShadowNoise.xy,ShadowNoise.zw)));
	 float4 DiskSin=0.0, DiskCos=0.0;
	 sincos((Noise+float4(2.0,3.0,4.0,5.0))*2.4,DiskSin,DiskCos);
	 float4 Disk1=float4(DiskSin.x,DiskCos.x,DiskSin.y,DiskCos.y)*ShadowBlur.xxyy;
	 float4 Disk2=float4(DiskSin.z,DiskCos.z,DiskSin.w,DiskCos.w)*ShadowBlur.zzww;
	 IN.ShadowProj /=IN.Depth.xxyy;
	 float Depth=length(LightPosition1.xyz-IN.WorldPos.xyz)/LightPosition1.w;
	 float4 ShadowMap=float4(tex2D(ShadowMapSampler,IN.ShadowProj.xy+Disk1.xy).y,tex2D(ShadowMapSampler,IN.ShadowProj.xy+Disk1.zw).y,tex2D(ShadowMapSampler,IN.ShadowProj.xy+Disk2.xy).y,tex2D(ShadowMapSampler,IN.ShadowProj.xy+Disk2.zw).y);
         float4 SpotShadow=saturate(LightMask1+dot(step(Depth,ShadowMap),0.25));
	 Depth=length(LightPosition2.xyz-IN.WorldPos.xyz)/LightPosition2.w;
         ShadowMap=float4(tex2D(ShadowMapSampler,IN.ShadowProj.zw+Disk1.xy).z,tex2D(ShadowMapSampler,IN.ShadowProj.zw+Disk1.zw).z,tex2D(ShadowMapSampler,IN.ShadowProj.zw+Disk2.xy).z,tex2D(ShadowMapSampler,IN.ShadowProj.zw+Disk2.zw).z);
         SpotShadow *=saturate(LightMask2+dot(step(Depth,ShadowMap),0.25));
         ShadowMap=float4(tex2D(ShadowMapSampler,IN.Tex2.zw+Disk1.xy).x,tex2D(ShadowMapSampler,IN.Tex2.zw+Disk1.zw).x,tex2D(ShadowMapSampler,IN.Tex2.zw+Disk2.xy).x,tex2D(ShadowMapSampler,IN.Tex2.zw+Disk2.zw).x);
	 ShadowMap=step(IN.ViewNor.w,ShadowMap)+saturate(12.0*(IN.ViewNor.w-ShadowMap))+max(dot(IN.TBNRow3.xyz,DirectionShadow),0.0);
	#else
         float4 ShadowMap=1.0, SpotShadow=1.0;
	#endif
	float4 LightmapX=tex2D(LightMapXSampler,IN.Tex2.xy); LightmapX.xyz=(LightmapX.xyz*pow(1.04,LightmapX.w*255.0-128.0))-5.0;
	float4 LightmapY=tex2D(LightMapYSampler,IN.Tex2.xy); LightmapY.xyz=(LightmapY.xyz*pow(1.04,LightmapY.w*255.0-128.0))-5.0;
	float4 LightmapZ=tex2D(LightMapZSampler,IN.Tex2.xy); LightmapZ.xyz=(LightmapZ.xyz*pow(1.04,LightmapZ.w*255.0-128.0))-5.0;
	float3 Lighting=pow(dot(saturate(ShadowMap),0.25)*max(LightmapX.xyz*Normals.x+LightmapY.xyz*Normals.y+LightmapZ.xyz*Normals.z,0.0),2.2);
	#if Specularity == 1
	 float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2.5);
	 float Denominator=Distribution.x-1.0;
	 float3 LightDirX=normalize(ViewVec+float3(LightmapX.x,LightmapY.x,LightmapZ.x));
	 float3 LightDirY=normalize(ViewVec+float3(LightmapX.y,LightmapY.y,LightmapZ.y));
	 float3 LightDirZ=normalize(ViewVec+float3(LightmapX.z,LightmapY.z,LightmapZ.z));
	 float3 HalfVec=float3(dot(LightDirX,Normals),dot(LightDirY,Normals),dot(LightDirZ,Normals))*Denominator+1.0005;
	 HalfVec=(Distribution/(3.141592*HalfVec*HalfVec))*Lighting;
	 float3 LightSpecular=max(HalfVec.x,max(HalfVec.y,HalfVec.z))*Lighting;
	#else
	 float3 LightSpecular=0.0;
	#endif
	for (int l=0; l < DynamicPointCount; l++) {
	 float3 LightVec=float3(PointPositionX[l],PointPositionY[l],PointPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(PointRed[l],PointGreen[l],PointBlue[l])*max(dot(LightVec,Normals),0.0)*max(1.0/(Attenuation/PointRange[l])-1.0,0.0);
	 Lighting +=Light;
	 #if Specularity == 1
	  HalfVec.x=max(dot(normalize(LightVec+ViewVec),Normals),0.0)*Denominator+1.0005;
	  LightSpecular +=(Distribution/(3.141592*HalfVec.x*HalfVec.x))*Light;
	 #endif
	}
	for (int l=0; l < DynamicSpotCount; l++) {
	 float3 LightVec=float3(SpotPositionX[l],SpotPositionY[l],SpotPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(SpotRed[l],SpotGreen[l],SpotBlue[l])*max(dot(LightVec,Normals),0.0)*max(1.0/(Attenuation/SpotRange[l])-1.0,0.0)*SpotShadow[l];
	 Light *=saturate((dot(LightVec,float3(SpotDirX[l],SpotDirY[l],SpotDirZ[l]))-SpotMin[l])/SpotMax[l]);
	 Lighting +=Light;
	 #if Specularity == 1
	  HalfVec.x=max(dot(normalize(LightVec+ViewVec),Normals),0.0)*Denominator+1.0005;
	  LightSpecular +=(Distribution/(3.141592*HalfVec.x*HalfVec.x))*Light;
	 #endif
	}
	#if ParallaxReflection == 0
	 float3 ViewReflection=reflect(ViewVec,Normals);
        #else
	 float3 BoxMin=float3(IN.TBNRow1.w,IN.TBNRow2.w,IN.TBNRow3.w);
	 float3 ViewReflection=reflect(-ViewVec,Normals);
	 float3 ReflectionBox=max((BoxMin-IN.WorldPos.xyz)/ViewReflection,(IN.BoxMax-IN.WorldPos.xyz)/ViewReflection);
	 ViewReflection=IN.WorldPos+ViewReflection*min(min(ReflectionBox.x,ReflectionBox.y),ReflectionBox.z);
	 ViewReflection=-normalize(ViewReflection-(BoxMin+((IN.BoxMax-BoxMin)*0.5)));
	#endif
	float2 Equirectangular=0.3183*float2(atan2(-ViewReflection.z,ViewReflection.x),acos(ViewReflection.y));
	float4 Reflections=tex2Dlod(ReflectionSampler,float4(Equirectangular.x*0.5+0.5,1.0025-Equirectangular.y,0.0,NormalMap.z*5.0));
	LightSpecular +=Reflections.xyz*pow(1.04,Reflections.w*255.0-128.0);
	Lighting +=AmbientColor*Secondarys.y;
	Lighting *=(1.0-Specular)*(1.0-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*32.0);
        float2 FogDist=saturate(1.0-exp(-(IN.Depth.z/float2(FogColor.w,WaterFogColor.w))));
        FogDist.y *=saturate(-IN.WorldPos.y+WaterFogHeight);
	return float4(lerp(lerp(Lighting,FogColor.xyz,FogDist.x),WaterFogColor.xyz,FogDist.y),ceil(Diffuse.w-0.25)*IN.Depth.z);
     }
   float4 PS_Reflection(Out_Lighting IN)  : COLOR
     {
	float4 Diffuse=tex2D(BaseSampler,IN.Tex.xy);
	float4 NormalMap=tex2D(NormalMapSampler,IN.Tex.xy);
	float4 Secondarys=tex2D(SecondarysSampler,IN.Tex.xy);
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos.xyz);
	float ViewNormal=max(dot(ViewVec,IN.TBNRow3),0.0);
	Diffuse.xyz=pow(Diffuse.xyz,2.2);
	float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
	Specular +=(1.0-Specular)*(1.0-NormalMap.z)*pow(1.0-ViewNormal,5.0);
	float4 LightmapX=tex2D(LightMapXSampler,IN.Tex2.xy); LightmapX.xyz=(LightmapX.xyz*pow(1.04,LightmapX.w*255.0-128.0))-5.0;
	float4 LightmapY=tex2D(LightMapYSampler,IN.Tex2.xy); LightmapY.xyz=(LightmapY.xyz*pow(1.04,LightmapY.w*255.0-128.0))-5.0;
	float4 LightmapZ=tex2D(LightMapZSampler,IN.Tex2.xy); LightmapZ.xyz=(LightmapZ.xyz*pow(1.04,LightmapZ.w*255.0-128.0))-5.0;
	float3 Lighting=pow(max(LightmapX.xyz*IN.TBNRow3.x+LightmapY.xyz*IN.TBNRow3.y+LightmapZ.xyz*IN.TBNRow3.z,0.0),2.2);
	#if Shadows == 1
	 IN.ShadowProj /=IN.Depth.xxyy;
	 float Depth=length(LightPosition1.xyz-IN.WorldPos.xyz)/LightPosition1.w;
         float4 SpotShadow=saturate(LightMask1+step(Depth,tex2D(ShadowMapSampler,IN.ShadowProj.xy).y));
	 Depth=length(LightPosition2.xyz-IN.WorldPos.xyz)/LightPosition2.w;
         SpotShadow *=saturate(LightMask2+step(Depth,tex2D(ShadowMapSampler,IN.ShadowProj.zw).z));
	#else
         float4 SpotShadow=1;
	#endif
	for (int l=0; l < DynamicPointCount; l++) {
	 float3 LightVec=float3(PointPositionX[l],PointPositionY[l],PointPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 Lighting +=float3(PointRed[l],PointGreen[l],PointBlue[l])*max(dot(LightVec,IN.TBNRow3),0.0)*max(1.0/(Attenuation/PointRange[l])-1.0,0.0);
	}
	for (int l=0; l < DynamicSpotCount; l++) {
	 float3 LightVec=float3(SpotPositionX[l],SpotPositionY[l],SpotPositionZ[l])-IN.WorldPos.xyz;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(SpotRed[l],SpotGreen[l],SpotBlue[l])*max(dot(LightVec,IN.TBNRow3),0.0)*max(1.0/(Attenuation/SpotRange[l])-1.0,0.0)*SpotShadow[l];
	 Lighting +=Light*saturate((dot(LightVec,float3(SpotDirX[l],SpotDirY[l],SpotDirZ[l]))-SpotMin[l])/SpotMax[l]);
	}
	float3 ViewReflection=reflect(ViewVec,IN.TBNRow3);
	float2 Equirectangular=0.3183*float2(atan2(-ViewReflection.z,ViewReflection.x),acos(ViewReflection.y));
	float4 Reflections=tex2Dlod(ReflectionSampler,float4(Equirectangular.x*0.5+0.5,1.0025-Equirectangular.y,0.0,NormalMap.z*5.0));
	float3 LightSpecular=Reflections.xyz*pow(1.04,Reflections.w*255.0-128.0);
	Lighting +=AmbientColor*Secondarys.y;
	Lighting *=(1.0-Specular)*(1.0-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*32.0);
        float FogDist=saturate(1.0-exp(-(IN.Depth.z/FogColor.w)));
	Lighting=lerp(Lighting,FogColor.xyz,FogDist);
	float MaxComponent=max(max(Lighting.x,Lighting.y),Lighting.z);
	float fExp=ceil(log(MaxComponent)/log(1.04));
	fExp=saturate((fExp+128.0)/255.0);
	return float4(Lighting/pow(1.04,fExp*255.0-128.0),ceil(Diffuse.w-0.25)*fExp);
     }
   float4 PS_DepthMap(Out_Depth IN) : COLOR
     {
	return float4(0.01+length(IN.Depth/ShadowPosition.w).xxx,tex2D(BaseSampler,IN.Tex.xy).w);
     }
   float4 PS_DepthMapDir(Out_Depth IN) : COLOR
     {
	return float4(0.0001+IN.Depth,tex2D(BaseSampler,IN.Tex.xy).w);
     }

//--------------
// techniques 
//--------------
    technique Lighting
      {
 	pass p1
      {
 	vertexShader=compile vs_3_0 VS_Lighting(); 
 	pixelShader=compile ps_3_0 PS_Lighting();
	AlphaBlendEnable=false;
   	AlphaRef=64;
      }
      }
    technique Reflection
      {
 	pass p1
      {
 	vertexShader=compile vs_3_0 VS_Reflection();
 	pixelShader=compile ps_3_0 PS_Reflection();
	ClipPlaneEnable=1;
	CullMode=cw;
	AlphaBlendEnable=false;
   	AlphaRef=64;
      }
      }
    technique DepthMap0
      {
 	pass p1
      {
 	VertexShader=compile vs_3_0 VS_DepthMap();
 	PixelShader=compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
	AlphaRef=64;
	Cullmode=0;
      }
      }
    technique DepthMap1
      {
 	pass p1
      {
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
  	AlphaRef=64;
	Cullmode=0;
      }
      }
    technique DepthMap2
      {
 	pass p1
      {
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=2;
	AlphaBlendEnable=false;
  	AlphaRef=64;
	Cullmode=0;
      }
      }
    technique DepthMap3
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=4;
	AlphaBlendEnable=false;
  	AlphaRef=64;
	Cullmode=0;
      }
      }
    technique DepthMap4
      {
 	pass p1
      {
 	VertexShader=compile vs_3_0 VS_DepthMapDir();
 	PixelShader=compile ps_3_0 PS_DepthMapDir();
        ColorWriteEnable=1;
	AlphaBlendEnable=false;
  	AlphaRef=64;
	Cullmode=0;
      }
      }
    technique DepthMap6
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMap();
 	PixelShader=compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=2;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }
    technique DepthMap7
      {
 	pass p1
      {		
 	VertexShader=compile vs_3_0 VS_DepthMap();
 	PixelShader=compile ps_3_0 PS_DepthMap();
        ColorWriteEnable=4;
	AlphaBlendEnable=false;
  	AlphaRef=64;
      }
      }